/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.store.Constants;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class TSELEMENTS
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final int MAX_TZ_CACHE_ENTRIES = 64;
    private final Map<String, DateTimeZone> tzones = new LinkedHashMap<String, DateTimeZone>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, DateTimeZone> eldest) {
            return this.size() > 64;
        }
    };

    public TSELEMENTS(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object obj = stack.peek();
        String tz = null;
        if (obj instanceof String) {
            tz = (String)obj;
            stack.pop();
        } else if (!(obj instanceof Long)) {
            throw new WarpScriptException(this.getName() + " operates on a timestamp or a timestamp + timezone.");
        }
        DateTimeZone dtz = this.tzones.get(tz);
        if (null == dtz) {
            dtz = DateTimeZone.forID((String)(null == tz ? "UTC" : tz));
            this.tzones.put(tz, dtz);
        }
        if (!((obj = stack.pop()) instanceof Long)) {
            throw new WarpScriptException(this.getName() + " operates on a timestamp or a timestamp + timezone.");
        }
        long ts = (Long)obj;
        long tsms = ts / Constants.TIME_UNITS_PER_MS;
        if (0L > ts && 0L != ts % Constants.TIME_UNITS_PER_MS) {
            --tsms;
        }
        DateTime dt = new DateTime(tsms, dtz);
        ArrayList<Long> elements = new ArrayList<Long>();
        elements.add(Long.valueOf(dt.getYear()));
        elements.add(Long.valueOf(dt.getMonthOfYear()));
        elements.add(Long.valueOf(dt.getDayOfMonth()));
        elements.add(Long.valueOf(dt.getHourOfDay()));
        elements.add(Long.valueOf(dt.getMinuteOfHour()));
        elements.add(Long.valueOf(dt.getSecondOfMinute()));
        elements.add((long)dt.getMillisOfSecond() * Constants.TIME_UNITS_PER_MS + Math.abs(ts - tsms * Constants.TIME_UNITS_PER_MS));
        elements.add(Long.valueOf(dt.getDayOfYear()));
        elements.add(Long.valueOf(dt.getDayOfWeek()));
        elements.add(Long.valueOf(dt.getWeekOfWeekyear()));
        stack.push(elements);
        return stack;
    }
}

