/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.store.Constants;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.PGPPUBLIC;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.bouncycastle.bcpg.attr.ImageAttribute;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.bouncycastle.util.encoders.Hex;

public class PGPINFO
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public static final String KEY_MASTER = "master";
    public static final String KEY_SIGNING = "signing";
    public static final String KEY_ENCRYPTION = "encryption";
    public static final String KEY_EXPIRY = "expiry";
    public static final String KEY_PUBKEY = "pubkey";
    public static final String KEY_ATTR = "attributes";

    public PGPINFO(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (top instanceof PGPSecretKeyRing || top instanceof PGPPublicKeyRing) {
            LinkedHashMap keys = new LinkedHashMap();
            Iterator pubiter = null;
            if (top instanceof PGPSecretKeyRing) {
                PGPSecretKeyRing keyring = (PGPSecretKeyRing)top;
                Iterator iter = keyring.getSecretKeys();
                while (iter.hasNext()) {
                    PGPSecretKey key = (PGPSecretKey)iter.next();
                    LinkedHashMap<String, Object> infos = new LinkedHashMap<String, Object>();
                    String keyid = "000000000000000" + Long.toHexString(key.getKeyID());
                    keyid = keyid.substring(keyid.length() - 16, keyid.length()).toUpperCase();
                    infos.put("keyid", keyid);
                    infos.put("fingerprint", Hex.toHexString((byte[])key.getPublicKey().getFingerprint()));
                    ArrayList uids = new ArrayList();
                    Iterator uiditer = key.getPublicKey().getRawUserIDs();
                    while (uiditer.hasNext()) {
                        uids.add(uiditer.next());
                    }
                    infos.put("uid", uids);
                    infos.put("bits", Long.valueOf(key.getPublicKey().getBitStrength()));
                    infos.put("algorithm", PGPPUBLIC.getPublicKeyAlgorithmName(key.getPublicKey().getAlgorithm()));
                    infos.put(KEY_MASTER, key.isMasterKey());
                    infos.put(KEY_SIGNING, key.isSigningKey());
                    long creation = key.getPublicKey().getCreationTime().getTime();
                    infos.put(KEY_ENCRYPTION, key.getPublicKey().isEncryptionKey());
                    infos.put(KEY_EXPIRY, 0L == key.getPublicKey().getValidSeconds() ? 0L : (creation + key.getPublicKey().getValidSeconds() * 1000L) * Constants.TIME_UNITS_PER_MS);
                    infos.put(KEY_PUBKEY, key.getPublicKey());
                    Iterator ater = key.getUserAttributes();
                    ArrayList<byte[]> attributes = new ArrayList<byte[]>();
                    while (ater.hasNext()) {
                        PGPUserAttributeSubpacketVector uat = (PGPUserAttributeSubpacketVector)ater.next();
                        ImageAttribute img = uat.getImageAttribute();
                        if (null == img) continue;
                        attributes.add(img.getImageData());
                    }
                    infos.put(KEY_ATTR, attributes);
                    keys.put(keyid, infos);
                }
                pubiter = keyring.getExtraPublicKeys();
            } else {
                pubiter = ((PGPPublicKeyRing)top).getPublicKeys();
            }
            while (pubiter.hasNext()) {
                PGPPublicKey key = (PGPPublicKey)pubiter.next();
                LinkedHashMap<String, Object> infos = new LinkedHashMap<String, Object>();
                String keyid = "000000000000000" + Long.toHexString(key.getKeyID());
                keyid = keyid.substring(keyid.length() - 16, keyid.length()).toUpperCase();
                infos.put("keyid", keyid);
                infos.put("fingerprint", Hex.toHexString((byte[])key.getFingerprint()));
                ArrayList uids = new ArrayList();
                Iterator uiditer = key.getRawUserIDs();
                while (uiditer.hasNext()) {
                    uids.add(uiditer.next());
                }
                infos.put("uid", uids);
                infos.put("bits", Long.valueOf(key.getBitStrength()));
                infos.put("algorithm", PGPPUBLIC.getPublicKeyAlgorithmName(key.getAlgorithm()));
                infos.put(KEY_MASTER, key.isMasterKey());
                infos.put(KEY_SIGNING, false);
                infos.put(KEY_ENCRYPTION, key.isEncryptionKey());
                long creation = key.getCreationTime().getTime();
                infos.put(KEY_EXPIRY, 0L == key.getValidSeconds() ? 0L : (creation + key.getValidSeconds() * 1000L) * Constants.TIME_UNITS_PER_MS);
                infos.put(KEY_PUBKEY, key);
                Iterator ater = key.getUserAttributes();
                ArrayList<byte[]> attributes = new ArrayList<byte[]>();
                while (ater.hasNext()) {
                    PGPUserAttributeSubpacketVector uat = (PGPUserAttributeSubpacketVector)ater.next();
                    ImageAttribute img = uat.getImageAttribute();
                    if (null == img) continue;
                    attributes.add(img.getImageData());
                }
                infos.put(KEY_ATTR, attributes);
                keys.put(keyid, infos);
            }
            stack.push(keys);
        } else if (top instanceof PGPPublicKey) {
            PGPPublicKey key = (PGPPublicKey)top;
            LinkedHashMap<String, Object> infos = new LinkedHashMap<String, Object>();
            String keyid = "000000000000000" + Long.toHexString(key.getKeyID());
            keyid = keyid.substring(keyid.length() - 16, keyid.length()).toUpperCase();
            infos.put("keyid", keyid);
            infos.put("fingerprint", Hex.toHexString((byte[])key.getFingerprint()));
            ArrayList uids = new ArrayList();
            Iterator uiditer = key.getRawUserIDs();
            while (uiditer.hasNext()) {
                uids.add(uiditer.next());
            }
            infos.put("uid", uids);
            infos.put("bits", Long.valueOf(key.getBitStrength()));
            infos.put("algorithm", PGPPUBLIC.getPublicKeyAlgorithmName(key.getAlgorithm()));
            infos.put(KEY_MASTER, key.isMasterKey());
            infos.put(KEY_SIGNING, false);
            infos.put(KEY_ENCRYPTION, key.isEncryptionKey());
            long creation = key.getCreationTime().getTime();
            infos.put(KEY_EXPIRY, 0L == key.getValidSeconds() ? 0L : (creation + key.getValidSeconds() * 1000L) * Constants.TIME_UNITS_PER_MS);
            infos.put(KEY_PUBKEY, key);
            stack.push(infos);
        } else {
            throw new WarpScriptException(this.getName() + " expected a PGP public key or secret key ring.");
        }
        return stack;
    }
}

