/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.MemoryWarpScriptStack;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.ECPUBLIC;
import io.warp10.script.functions.ECSIGN;
import io.warp10.script.functions.MSIG;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;

public class MSIGN
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final ECSIGN ECSIGN = new ECSIGN("ECSIGN");
    private static final ECPUBLIC ECPUBLIC = new ECPUBLIC("ECPUBLIC");
    private static final MSIG MSIG = new MSIG("MSIG");

    public MSIGN(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof ECPrivateKey)) {
            throw new WarpScriptException(this.getName() + " expects an ECC private key.");
        }
        ECPrivateKey privateKey = (ECPrivateKey)top;
        top = stack.pop();
        if (!(top instanceof WarpScriptStack.Macro)) {
            throw new WarpScriptException(this.getName() + " operates on a macro.");
        }
        WarpScriptStack.Macro macro = (WarpScriptStack.Macro)top;
        String snapshot = macro.snapshot(false);
        byte[] data = snapshot.getBytes(StandardCharsets.UTF_8);
        MemoryWarpScriptStack stck = new MemoryWarpScriptStack(null, null);
        stck.push(data);
        stck.push("SHA256WITHECDSA");
        stck.push(privateKey);
        ECSIGN.apply(stck);
        byte[] sig = (byte[])stck.pop();
        stck.push(privateKey);
        ECPUBLIC.apply(stck);
        ECPublicKey pub = (ECPublicKey)stck.pop();
        WarpScriptStack.Macro sigmacro = new WarpScriptStack.Macro();
        sigmacro.add(((ECNamedCurveParameterSpec)pub.getParameters()).getName());
        sigmacro.add(Hex.encodeHexString((byte[])pub.getEncoded()));
        sigmacro.add(Hex.encodeHexString((byte[])sig));
        sigmacro.add(MSIG);
        stack.push(macro);
        stack.push(sigmacro);
        return stack;
    }
}

