/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.WarpConfig;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;

public class MACROCONFIG
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final boolean defaultValue;

    public MACROCONFIG(String name, boolean defaultValue) {
        super(name);
        this.defaultValue = defaultValue;
    }

    public MACROCONFIG(String name) {
        this(name, false);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        String macro = (String)stack.getAttribute("macro.name");
        if (null == macro) {
            throw new WarpScriptException(this.getName() + " can only be used from named macro.");
        }
        Object top = stack.pop();
        String defVal = null;
        if (this.defaultValue) {
            defVal = null == top ? null : String.valueOf(top);
            top = stack.pop();
        }
        if (!(top instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a macro configuration key name.");
        }
        String key = String.valueOf(top).trim();
        String value = null;
        ArrayList<String> attempts = new ArrayList<String>();
        boolean resolved = false;
        String m = macro;
        while (true) {
            attempts.add(key + "@" + m);
            value = WarpConfig.getProperty(key + "@" + m);
            if (null != value) {
                resolved = true;
                break;
            }
            if (!m.contains("/")) break;
            m = m.replaceAll("/[^/]+$", "");
        }
        if (resolved) {
            stack.push(value);
            return stack;
        }
        if (this.defaultValue) {
            stack.push(defVal);
            return stack;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName() + " macro configuration '" + key + "' not found, need to set one of [");
        for (String attempt : attempts) {
            sb.append(" '" + attempt + "'");
        }
        sb.append(" ].");
        throw new WarpScriptException(sb.toString());
    }
}

