/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.ECGEN;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.math.ec.ECPoint;

public class ECPUBLIC
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public ECPUBLIC(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (top instanceof ECPublicKey) {
            ECPublicKey pubkey = (ECPublicKey)top;
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            ECNamedCurveParameterSpec curve = (ECNamedCurveParameterSpec)pubkey.getParameters();
            params.put("curve", curve.getName());
            params.put("Q", Hex.encodeHexString((byte[])pubkey.getEncoded()));
            stack.push(params);
            return stack;
        }
        if (!(top instanceof Map) && !(top instanceof ECPrivateKey)) {
            throw new WarpScriptException(this.getName() + " expects a parameter map, or a public or private key.");
        }
        if (top instanceof ECPrivateKey) {
            ECPrivateKey privateKey = (ECPrivateKey)top;
            final ECParameterSpec bcSpec = privateKey.getParameters();
            final ECPoint q = bcSpec.getG().multiply(privateKey.getD());
            ECPublicKey publicKey = new ECPublicKey(){

                public String getFormat() {
                    return "PKCS#8";
                }

                public byte[] getEncoded() {
                    return q.getEncoded(false);
                }

                public String getAlgorithm() {
                    return "EC";
                }

                public ECParameterSpec getParameters() {
                    return bcSpec;
                }

                public ECPoint getQ() {
                    return q;
                }
            };
            stack.push(publicKey);
            return stack;
        }
        Map params = (Map)top;
        String name = String.valueOf(params.get("curve"));
        final ECNamedCurveParameterSpec curve = ECNamedCurveTable.getParameterSpec((String)name);
        if (null == curve) {
            throw new WarpScriptException(this.getName() + " curve name '" + name + "' not in " + ECGEN.getCurves() + ".");
        }
        if (!(params.get("Q") instanceof String)) {
            throw new WarpScriptException(this.getName() + " missing or non-String parameter '" + "Q" + "'.");
        }
        final byte[] encoded = org.bouncycastle.util.encoders.Hex.decode((String)((String)params.get("Q")));
        final ECPoint q = curve.getCurve().decodePoint(encoded);
        ECPublicKey publicKey = new ECPublicKey(){

            public String getFormat() {
                return "PKCS#8";
            }

            public byte[] getEncoded() {
                return encoded;
            }

            public String getAlgorithm() {
                return "EC";
            }

            public ECParameterSpec getParameters() {
                return curve;
            }

            public ECPoint getQ() {
                return q;
            }
        };
        stack.push(publicKey);
        return stack;
    }
}

