/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class CHRONOSTATS
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public static final String key = "chronostats";

    public CHRONOSTATS(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Map stats = (Map)stack.getAttribute(key);
        if (null == stats) {
            stack.push(null);
        } else {
            HashMap result = new HashMap();
            for (Map.Entry entry : stats.entrySet()) {
                HashMap<String, Long> macro_result = new HashMap<String, Long>();
                macro_result.put("total_time", ((AtomicLong[])entry.getValue())[0].longValue());
                macro_result.put("total_calls", ((AtomicLong[])entry.getValue())[1].longValue());
                result.put(entry.getKey(), macro_result);
            }
            stack.push(result);
        }
        return stack;
    }

    static String getStartKey(String alias, WarpScriptStack stack) {
        return "chrono_start_" + alias + "_" + stack.getUUID();
    }

    static String getActiveCountKey(String alias, WarpScriptStack stack) {
        return "chrono_active_" + alias + "_" + stack.getUUID();
    }

    static String getTotalCountKey(String alias, WarpScriptStack stack) {
        return "chrono_calls_" + alias + "_" + stack.getUUID();
    }
}

