/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.fastdtw;

import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.fastdtw.ColMajorCell;
import io.warp10.script.fastdtw.SearchWindow;
import io.warp10.script.fastdtw.WarpPath;

public class ExpandedResWindow
extends SearchWindow {
    public ExpandedResWindow(GeoTimeSerie tsI, GeoTimeSerie tsJ, GeoTimeSerie shrunkI, GeoTimeSerie shrunkJ, WarpPath shrunkWarpPath, int searchRadius) {
        super(tsI.size(), tsJ.size());
        int stdBlockISize = tsI.size() / shrunkI.size();
        int stdBlockJSize = tsJ.size() / shrunkJ.size();
        int lastBlockISize = stdBlockISize + tsI.size() % shrunkI.size();
        int lastBlockJSize = stdBlockJSize + tsJ.size() % shrunkJ.size();
        int currentI = shrunkWarpPath.minI();
        int currentJ = shrunkWarpPath.minJ();
        int lastWarpedI = Integer.MAX_VALUE;
        int lastWarpedJ = Integer.MAX_VALUE;
        for (int w = 0; w < shrunkWarpPath.size(); ++w) {
            int blockJSize;
            ColMajorCell currentCell = shrunkWarpPath.get(w);
            int warpedI = currentCell.getCol();
            int warpedJ = currentCell.getRow();
            int blockISize = shrunkI.size() - 1 == warpedI ? lastBlockISize : stdBlockISize;
            int n = blockJSize = shrunkJ.size() - 1 == warpedJ ? lastBlockJSize : stdBlockJSize;
            if (warpedJ > lastWarpedJ) {
                currentJ += shrunkJ.size() - 1 == lastWarpedJ ? lastBlockJSize : stdBlockJSize;
            }
            if (warpedI > lastWarpedI) {
                currentI += shrunkI.size() - 1 == lastWarpedI ? lastBlockISize : stdBlockISize;
            }
            if (warpedJ > lastWarpedJ && warpedI > lastWarpedI) {
                super.markVisited(currentI - 1, currentJ);
                super.markVisited(currentI, currentJ - 1);
            }
            for (int x = 0; x < blockISize; ++x) {
                super.markVisited(currentI + x, currentJ);
                super.markVisited(currentI + x, currentJ + blockJSize - 1);
            }
            lastWarpedI = warpedI;
            lastWarpedJ = warpedJ;
        }
        super.expandWindow(searchRadius);
    }
}

