/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.ext.shm;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.ext.shm.SharedMemoryWarpScriptExtension;
import io.warp10.warp.sdk.Capabilities;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;

public class SHMSTORE
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public SHMSTORE(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        String cap = Capabilities.get(stack, "shmstore");
        if (null == cap) {
            throw new WarpScriptException(this.getName() + " expected capability '" + "shmstore" + "' to be set.");
        }
        Object mutexo = stack.getAttribute("ext.shm.mutex" + stack.getUUID());
        if (null == mutexo) {
            throw new WarpScriptException(this.getName() + " can only be called when in a MUTEX section.");
        }
        String mutex = String.valueOf(mutexo);
        Object top = stack.pop();
        if (!(top instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a symbol name.");
        }
        String symbol = (String)top;
        top = stack.pop();
        if (!"".equals(cap) && !Pattern.matches(cap, symbol)) {
            throw new WarpScriptException(this.getName() + " capability does not grant access to symbol '" + symbol + "'.");
        }
        ReentrantLock lock = SharedMemoryWarpScriptExtension.getLock(mutex);
        if (!lock.isHeldByCurrentThread()) {
            throw new WarpScriptException(this.getName() + " expects the mutex '" + mutex + "' to be held when calling " + this.getName());
        }
        SharedMemoryWarpScriptExtension.store(symbol, mutex, top);
        return stack;
    }
}

