/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script;

import io.warp10.WarpURLEncoder;
import io.warp10.continuum.gts.UnsafeString;
import io.warp10.json.JsonUtils;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.SNAPSHOT;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;

public class StackUtils {
    public static void toJSON(PrintWriter out, WarpScriptStack stack, int maxdepth, long maxJsonSize) throws WarpScriptException, IOException {
        boolean strictJSON = Boolean.TRUE.equals(stack.getAttribute("json.strict"));
        boolean prettyJSON = Boolean.TRUE.equals(stack.getAttribute("json.pretty"));
        int depth = Math.min(stack.depth(), maxdepth);
        out.print("[");
        boolean first = true;
        for (int i = 0; i < depth; ++i) {
            if (!first) {
                out.print(",");
            }
            first = false;
            Object o = stack.get(i);
            JsonUtils.objectToJson(out, o, strictJSON, prettyJSON, maxJsonSize);
        }
        out.print("]");
    }

    public static void toJSON(PrintWriter out, WarpScriptStack stack) throws WarpScriptException, IOException {
        StackUtils.toJSON(out, stack, Integer.MAX_VALUE, Long.MAX_VALUE);
    }

    public static StringBuilder sanitize(String script) throws WarpScriptException {
        StringBuilder sb = new StringBuilder();
        if (null == script) {
            return sb;
        }
        BufferedReader br = new BufferedReader(new StringReader(script));
        boolean inComment = false;
        try {
            String line;
            block2: while (null != (line = br.readLine())) {
                line = line.trim();
                String[] statements = -1 != (line = UnsafeString.sanitizeStrings(line)).indexOf(32) ? UnsafeString.split(line, ' ') : new String[]{line};
                for (String stmt : statements) {
                    if (0 == stmt.length()) continue;
                    if ((stmt = stmt.trim()).charAt(0) == '#' || stmt.charAt(0) == '/' && stmt.length() >= 2 && stmt.charAt(1) == '/') continue block2;
                    if ("*/".equals(stmt)) {
                        if (inComment) {
                            throw new WarpScriptException("Not inside a comment.");
                        }
                        inComment = false;
                        continue;
                    }
                    if (inComment) continue;
                    if ("/*".equals(stmt)) {
                        inComment = true;
                        continue;
                    }
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append(stmt);
                }
            }
            br.close();
        }
        catch (IOException ioe) {
            throw new WarpScriptException(ioe);
        }
        return sb;
    }

    public static String toString(Object o) {
        StringBuilder sb = new StringBuilder();
        if (null == o) {
            sb.append("NULL");
        } else if (o instanceof Number) {
            sb.append(o);
        } else if (o instanceof String) {
            sb.append("'");
            try {
                sb.append(WarpURLEncoder.encode(o.toString(), StandardCharsets.UTF_8));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            sb.append("'");
        } else if (o instanceof Boolean) {
            sb.append(Boolean.toString((Boolean)o));
        } else if (o instanceof WarpScriptStackFunction) {
            sb.append(o.toString());
        } else if (o instanceof SNAPSHOT.Snapshotable) {
            ((SNAPSHOT.Snapshotable)o).snapshot();
        } else if (o instanceof NamedWarpScriptFunction) {
            sb.append(o.toString());
        }
        return sb.toString();
    }
}

