/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.json;

import java.io.IOException;
import java.io.Writer;

public class BoundedWriter
extends Writer {
    protected final Writer writer;
    protected final long maxWrittenChars;
    protected long currentWrittenChars;

    public BoundedWriter(Writer writer, long maxAppendedChars) {
        this.writer = writer;
        this.maxWrittenChars = maxAppendedChars;
        this.currentWrittenChars = 0L;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if ((long)len + this.currentWrittenChars - this.maxWrittenChars > 0L) {
            throw new WriterBoundReachedException("Cannot write, maximum number of characters written :" + this.maxWrittenChars);
        }
        this.currentWrittenChars += (long)len;
        this.writer.write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public static class WriterBoundReachedException
    extends IOException {
        public WriterBoundReachedException(String message) {
            super(message);
        }
    }
}

