/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.continuum.gts;

import io.warp10.continuum.store.thrift.data.Metadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class MetadataTextComparator
implements Comparator<Metadata> {
    private final List<String> fields;
    private final boolean fieldsConsiderAttributes;

    public MetadataTextComparator(List<String> fields) {
        this.fields = fields;
        this.fieldsConsiderAttributes = false;
    }

    public MetadataTextComparator(List<String> fields, boolean fieldsConsiderAttributes) {
        this.fields = fields;
        this.fieldsConsiderAttributes = fieldsConsiderAttributes;
    }

    @Override
    public int compare(Metadata o1, Metadata o2) {
        int idx;
        int comp;
        if (null == o1 && null == o2) {
            return 0;
        }
        if (null == o1) {
            return -1;
        }
        if (null == o2) {
            return 1;
        }
        if (null != this.fields && !this.fields.isEmpty()) {
            return this.compareWithFields(o1, o2);
        }
        String name1 = o1.getName();
        String name2 = o2.getName();
        if (null == name1 && null != name2) {
            return -1;
        }
        if (null == name2 && null != name1) {
            return 1;
        }
        if (null != name1 && 0 != (comp = name1.compareTo(name2))) {
            return comp;
        }
        int size1 = o1.getLabelsSize();
        int size2 = o2.getLabelsSize();
        if (0 == size1 && 0 != size2) {
            return -1;
        }
        if (0 == size2 && 0 != size1) {
            return 1;
        }
        ArrayList<String> labels1 = new ArrayList<String>(size1);
        labels1.addAll(o1.getLabels().keySet());
        ArrayList<String> labels2 = new ArrayList<String>(size2);
        labels2.addAll(o2.getLabels().keySet());
        Collections.sort(labels1);
        Collections.sort(labels2);
        for (idx = 0; idx < size1 && idx < size2; ++idx) {
            comp = ((String)labels1.get(idx)).compareTo((String)labels2.get(idx));
            if (0 != comp) {
                return comp;
            }
            comp = o1.getLabels().get(labels1.get(idx)).compareTo(o2.getLabels().get(labels2.get(idx)));
            if (0 == comp) continue;
            return comp;
        }
        if (size1 < size2) {
            return -1;
        }
        if (size1 > size2) {
            return 1;
        }
        size1 = o1.getAttributesSize();
        size2 = o2.getAttributesSize();
        if (0 == size1 && 0 == size2) {
            return 0;
        }
        if (0 == size1) {
            return -1;
        }
        if (0 == size2) {
            return 1;
        }
        ArrayList<String> attr1 = new ArrayList<String>(size1);
        attr1.addAll(o1.getAttributes().keySet());
        ArrayList<String> attr2 = new ArrayList<String>(size2);
        attr2.addAll(o2.getAttributes().keySet());
        Collections.sort(attr1);
        Collections.sort(attr2);
        for (idx = 0; idx < size1 && idx < size2; ++idx) {
            comp = ((String)attr1.get(idx)).compareTo((String)attr2.get(idx));
            if (0 != comp) {
                return comp;
            }
            comp = o1.getAttributes().get(attr1.get(idx)).compareTo(o2.getAttributes().get(attr2.get(idx)));
            if (0 == comp) continue;
            return comp;
        }
        return Integer.compare(size1, size2);
    }

    private int compareWithFields(Metadata o1, Metadata o2) {
        HashMap<String, String> m1 = new HashMap<String, String>();
        HashMap<String, String> m2 = new HashMap<String, String>();
        if (this.fieldsConsiderAttributes) {
            m1.putAll(o1.getAttributes());
            m2.putAll(o2.getAttributes());
        }
        m1.putAll(o1.getLabels());
        m2.putAll(o2.getLabels());
        for (String field : this.fields) {
            int comp;
            String s2;
            String s1;
            if (null == field) {
                s1 = o1.getName();
                s2 = o2.getName();
            } else {
                s1 = (String)m1.get(field);
                s2 = (String)m2.get(field);
            }
            if (null == s1 && null != s2) {
                return -1;
            }
            if (null == s2 && null != s1) {
                return 1;
            }
            if (null == s1 || 0 == (comp = s1.compareTo(s2))) continue;
            return comp;
        }
        return 0;
    }
}

