/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.continuum.gts;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.function.UnaryOperator;

public class COWList
implements List {
    private final int size;
    private int startIdx;
    private final int virtualSize;
    private long[] dataLong = null;
    private double[] dataDouble = null;
    private String[] dataString = null;
    private BitSet dataBoolean = null;
    private boolean readOnly;
    private ArrayList mutableCopy = null;
    private final TYPE dataType;

    public TYPE getDataType() {
        if (this.readOnly) {
            return this.dataType;
        }
        throw new RuntimeException("The list has been modified and may contains heterogeneous elements");
    }

    public COWList(long[] elementData, int startIdx, int length) {
        this.dataLong = elementData;
        this.size = elementData.length;
        this.initialRangeCheck(startIdx, length);
        this.dataType = TYPE.LONG;
        this.startIdx = startIdx;
        this.virtualSize = length;
        this.readOnly = true;
    }

    public COWList(double[] elementData, int startIdx, int length) {
        this.dataDouble = elementData;
        this.size = elementData.length;
        this.initialRangeCheck(startIdx, length);
        this.dataType = TYPE.DOUBLE;
        this.startIdx = startIdx;
        this.virtualSize = length;
        this.readOnly = true;
    }

    public COWList(BitSet elementData, int startIdx, int length) {
        this.dataBoolean = elementData;
        this.size = elementData.size();
        this.initialRangeCheck(startIdx, length);
        this.dataType = TYPE.BOOLEAN;
        this.startIdx = startIdx;
        this.virtualSize = length;
        this.readOnly = true;
    }

    public COWList(String[] elementData, int startIdx, int length) {
        this.dataString = elementData;
        this.size = elementData.length;
        this.initialRangeCheck(startIdx, length);
        this.dataType = TYPE.STRING;
        this.startIdx = startIdx;
        this.virtualSize = length;
        this.readOnly = true;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    private synchronized void initialDeepCopy() {
        if (this.readOnly) {
            this.mutableCopy = new ArrayList(this.virtualSize);
            switch (this.dataType) {
                case LONG: {
                    for (int i = 0; i < this.virtualSize; ++i) {
                        this.mutableCopy.add(this.dataLong[i + this.startIdx]);
                    }
                    break;
                }
                case DOUBLE: {
                    for (int i = 0; i < this.virtualSize; ++i) {
                        this.mutableCopy.add(this.dataDouble[i + this.startIdx]);
                    }
                    break;
                }
                case STRING: {
                    for (int i = 0; i < this.virtualSize; ++i) {
                        this.mutableCopy.add(this.dataString[i + this.startIdx]);
                    }
                    break;
                }
                case BOOLEAN: {
                    for (int i = 0; i < this.virtualSize; ++i) {
                        this.mutableCopy.add(this.dataBoolean.get(i + this.startIdx));
                    }
                    break;
                }
            }
            this.readOnly = false;
        }
    }

    private void initialRangeCheck(int startIndex, int length) {
        if (startIndex >= this.size || startIndex < 0) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(startIndex));
        }
        if (length < 0 || startIndex + length > this.size) {
            throw new IndexOutOfBoundsException("Start index(" + startIndex + ") + length(" + length + ") is greater than original array size(" + this.size + "), cannot create sublist");
        }
    }

    private void rangeCheck(int index) {
        if (index < 0 || index >= this.virtualSize) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private String outOfBoundsMsg(int index) {
        return "Index: " + index + ", Size: " + this.size;
    }

    @Override
    public int indexOf(Object o) {
        if (this.readOnly) {
            if (o == null) {
                return -1;
            }
            switch (this.dataType) {
                case LONG: {
                    for (int i = 0; i < this.virtualSize; ++i) {
                        if (!o.equals(this.dataLong[i + this.startIdx])) continue;
                        return i;
                    }
                    break;
                }
                case DOUBLE: {
                    for (int i = 0; i < this.virtualSize; ++i) {
                        if (!o.equals(this.dataDouble[i + this.startIdx])) continue;
                        return i;
                    }
                    break;
                }
                case STRING: {
                    for (int i = 0; i < this.virtualSize; ++i) {
                        if (!o.equals(this.dataString[i + this.startIdx])) continue;
                        return i;
                    }
                    break;
                }
                case BOOLEAN: {
                    for (int i = 0; i < this.virtualSize; ++i) {
                        if (!o.equals(this.dataBoolean.get(i + this.startIdx))) continue;
                        return i;
                    }
                    break;
                }
            }
            return -1;
        }
        return this.mutableCopy.indexOf(o);
    }

    @Override
    public int size() {
        if (this.readOnly) {
            return this.virtualSize;
        }
        return this.mutableCopy.size();
    }

    @Override
    public boolean isEmpty() {
        if (this.readOnly) {
            return 0 == this.virtualSize;
        }
        return this.mutableCopy.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public Iterator iterator() {
        if (this.readOnly) {
            return new Iterator(){
                int cursor;

                @Override
                public boolean hasNext() {
                    return this.cursor != COWList.this.virtualSize;
                }

                public Object next() {
                    int i = this.cursor;
                    if (i >= COWList.this.virtualSize) {
                        throw new NoSuchElementException();
                    }
                    Object res = null;
                    switch (COWList.this.dataType) {
                        case LONG: {
                            res = COWList.this.dataLong[COWList.this.startIdx + i];
                            break;
                        }
                        case DOUBLE: {
                            res = COWList.this.dataDouble[COWList.this.startIdx + i];
                            break;
                        }
                        case STRING: {
                            res = COWList.this.dataString[COWList.this.startIdx + i];
                            break;
                        }
                        case BOOLEAN: {
                            res = COWList.this.dataBoolean.get(COWList.this.startIdx + i);
                        }
                    }
                    this.cursor = i + 1;
                    return res;
                }

                @Override
                public void remove() {
                }
            };
        }
        return this.mutableCopy.iterator();
    }

    @Override
    public boolean add(Object o) {
        this.initialDeepCopy();
        return this.mutableCopy.add(o);
    }

    @Override
    public boolean remove(Object o) {
        this.initialDeepCopy();
        return this.mutableCopy.remove(o);
    }

    @Override
    public boolean addAll(Collection c) {
        this.initialDeepCopy();
        return this.mutableCopy.addAll(c);
    }

    public boolean addAll(int index, Collection c) {
        this.initialDeepCopy();
        return this.mutableCopy.addAll(index, c);
    }

    public void replaceAll(UnaryOperator operator) {
        this.initialDeepCopy();
        this.mutableCopy.replaceAll(operator);
    }

    public void sort(Comparator c) {
        this.initialDeepCopy();
        this.mutableCopy.sort(c);
    }

    @Override
    public synchronized void clear() {
        this.mutableCopy = new ArrayList();
        this.readOnly = false;
    }

    public Object get(int index) {
        if (!this.readOnly) {
            return this.mutableCopy.get(index);
        }
        this.rangeCheck(index);
        switch (this.dataType) {
            case LONG: {
                return this.dataLong[index + this.startIdx];
            }
            case DOUBLE: {
                return this.dataDouble[index + this.startIdx];
            }
            case STRING: {
                return this.dataString[index + this.startIdx];
            }
            case BOOLEAN: {
                return this.dataBoolean.get(index + this.startIdx);
            }
        }
        return null;
    }

    public Object set(int index, Object element) {
        this.initialDeepCopy();
        return this.mutableCopy.set(index, element);
    }

    public void add(int index, Object element) {
        this.initialDeepCopy();
        this.mutableCopy.add(index, element);
    }

    public Object remove(int index) {
        this.initialDeepCopy();
        return this.mutableCopy.remove(index);
    }

    @Override
    public int lastIndexOf(Object o) {
        if (this.readOnly) {
            if (o == null) {
                return -1;
            }
            switch (this.dataType) {
                case LONG: {
                    for (int i = this.virtualSize - 1; i >= 0; --i) {
                        if (!o.equals(this.dataLong[i + this.startIdx])) continue;
                        return i;
                    }
                    break;
                }
                case DOUBLE: {
                    for (int i = this.virtualSize - 1; i >= 0; --i) {
                        if (!o.equals(this.dataDouble[i + this.startIdx])) continue;
                        return i;
                    }
                    break;
                }
                case STRING: {
                    for (int i = this.virtualSize - 1; i >= 0; --i) {
                        if (!o.equals(this.dataString[i + this.startIdx])) continue;
                        return i;
                    }
                    break;
                }
                case BOOLEAN: {
                    for (int i = this.virtualSize - 1; i >= 0; --i) {
                        if (!o.equals(this.dataBoolean.get(i + this.startIdx))) continue;
                        return i;
                    }
                    break;
                }
            }
            return -1;
        }
        return this.mutableCopy.lastIndexOf(o);
    }

    public ListIterator listIterator() {
        this.initialDeepCopy();
        return this.mutableCopy.listIterator();
    }

    public ListIterator listIterator(int index) {
        this.initialDeepCopy();
        return this.mutableCopy.listIterator(index);
    }

    public List subList(int fromIndex, int toIndex) {
        if (this.readOnly) {
            this.rangeCheck(fromIndex);
            int subsize = toIndex - fromIndex;
            if (subsize < 0 || subsize + toIndex > this.virtualSize) {
                throw new IndexOutOfBoundsException("Start index(" + fromIndex + ") + length(" + subsize + ") greater than original array size(" + this.virtualSize + "), cannot create sublist.");
            }
            COWList r = null;
            switch (this.dataType) {
                case LONG: {
                    r = new COWList(this.dataLong, fromIndex + this.startIdx, subsize);
                    break;
                }
                case DOUBLE: {
                    r = new COWList(this.dataDouble, fromIndex + this.startIdx, subsize);
                    break;
                }
                case STRING: {
                    r = new COWList(this.dataString, fromIndex + this.startIdx, subsize);
                    break;
                }
                case BOOLEAN: {
                    r = new COWList(this.dataBoolean, fromIndex + this.startIdx, subsize);
                }
            }
            return r;
        }
        return this.mutableCopy.subList(fromIndex, toIndex);
    }

    @Override
    public boolean retainAll(Collection c) {
        this.initialDeepCopy();
        return this.mutableCopy.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection c) {
        this.initialDeepCopy();
        return this.mutableCopy.removeAll(c);
    }

    @Override
    public boolean containsAll(Collection c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (this.readOnly) {
            Object[] r = a;
            if (r.length < this.virtualSize) {
                r = new Object[this.virtualSize];
            }
            switch (this.dataType) {
                case LONG: {
                    for (int i = 0; i < this.virtualSize; ++i) {
                        r[i] = this.dataLong[i + this.startIdx];
                    }
                    break;
                }
                case DOUBLE: {
                    for (int i = 0; i < this.virtualSize; ++i) {
                        r[i] = this.dataDouble[i + this.startIdx];
                    }
                    break;
                }
                case STRING: {
                    System.arraycopy(this.dataString, 0, r, 0, this.virtualSize);
                    break;
                }
                case BOOLEAN: {
                    for (int i = 0; i < this.virtualSize; ++i) {
                        r[i] = this.dataBoolean.get(i + this.startIdx);
                    }
                    break;
                }
            }
            return r;
        }
        return this.mutableCopy.toArray(a);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.virtualSize]);
    }

    public static enum TYPE {
        LONG,
        DOUBLE,
        BOOLEAN,
        STRING;

    }
}

