/*
 * Decompiled with CFR 0.152.
 */
package io.warp10;

import java.util.Arrays;

public class WarpHexDecoder {
    private static final byte[] decodingTable = new byte[103];

    public static byte[] decode(String str) throws IllegalArgumentException {
        int len = str.length();
        if (0 != len % 2) {
            throw new IllegalArgumentException("Odd number of hexadecimal digits.");
        }
        byte[] decoded = new byte[len >>> 1];
        int idx = 0;
        int bidx = 0;
        while (idx < len) {
            char c = str.charAt(idx++);
            char d = str.charAt(idx++);
            if (c > 'f' || d > 'f') {
                throw new IllegalArgumentException("Invalid hex character.");
            }
            byte b1 = decodingTable[c];
            byte b2 = decodingTable[d];
            if (b1 < 0 || b2 < 0) {
                throw new IllegalArgumentException("Invalid hex character.");
            }
            decoded[bidx++] = (byte)(b1 << 4 | b2);
        }
        return decoded;
    }

    static {
        Arrays.fill(decodingTable, (byte)-1);
        for (int i = 0; i < 10; ++i) {
            WarpHexDecoder.decodingTable[48 + i] = (byte)i;
        }
        WarpHexDecoder.decodingTable[65] = 10;
        WarpHexDecoder.decodingTable[66] = 11;
        WarpHexDecoder.decodingTable[67] = 12;
        WarpHexDecoder.decodingTable[68] = 13;
        WarpHexDecoder.decodingTable[69] = 14;
        WarpHexDecoder.decodingTable[70] = 15;
        WarpHexDecoder.decodingTable[97] = 10;
        WarpHexDecoder.decodingTable[98] = 11;
        WarpHexDecoder.decodingTable[99] = 12;
        WarpHexDecoder.decodingTable[100] = 13;
        WarpHexDecoder.decodingTable[101] = 14;
        WarpHexDecoder.decodingTable[102] = 15;
    }
}

