/*
 * Decompiled with CFR 0.152.
 */
package io.warp10;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class CustomThreadFactory
implements ThreadFactory {
    private final String name;
    private final ThreadGroup group;
    private final boolean isDaemon;
    private final int priority;
    private final AtomicInteger threadNumber = new AtomicInteger(1);

    public CustomThreadFactory(String name) {
        this(name, null, false, 5);
    }

    public CustomThreadFactory(String name, ThreadGroup group, boolean isDaemon, int priority) {
        SecurityManager s;
        this.name = name;
        this.group = null == group ? (null == (s = System.getSecurityManager()) ? Thread.currentThread().getThreadGroup() : s.getThreadGroup()) : group;
        this.isDaemon = isDaemon;
        this.priority = priority;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread t = new Thread(this.group, runnable, "[" + this.name + " #" + this.threadNumber.getAndIncrement() + "]", 0L);
        if (t.isDaemon() != this.isDaemon) {
            t.setDaemon(this.isDaemon);
        }
        if (this.priority != t.getPriority()) {
            t.setPriority(this.priority);
        }
        return t;
    }
}

