/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.mapper;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.mapper.MapperKernelSmoother;

public abstract class MapperKernel
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public MapperKernel(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a window width in ticks on top of the stack.");
        }
        int width = ((Number)top).intValue();
        if (0 == width % 2) {
            throw new WarpScriptException(this.getName() + " window width MUST be odd (we count ticks, not intervals).");
        }
        top = stack.pop();
        if (!(top instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a step length as a LONG.");
        }
        long step = ((Number)top).longValue();
        MapperKernelSmoother smoother = new MapperKernelSmoother(this.getName(), step, width, this.getWeights(step, width));
        stack.push(smoother);
        return stack;
    }

    abstract double[] getWeights(long var1, int var3);
}

