/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.mapper;

import com.geoxp.GeoXPLib;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.StackUtils;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptMapperFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.GEOPACK;

public class MapperGeoOutside
extends NamedWarpScriptFunction
implements WarpScriptMapperFunction {
    private final GeoXPLib.GeoXPShape shape;

    public MapperGeoOutside(String name, GeoXPLib.GeoXPShape shape) {
        super(name);
        this.shape = shape;
    }

    @Override
    public Object apply(Object[] args) throws WarpScriptException {
        long tick = (Long)args[0];
        long[] locations = (long[])args[4];
        long[] elevations = (long[])args[5];
        Object[] values = (Object[])args[6];
        if (values.length < 1) {
            return new Object[]{tick, 91480763316633925L, Long.MIN_VALUE, null};
        }
        long location = locations[0];
        long elevation = elevations[0];
        if (null == values[0] || 91480763316633925L == location || GeoXPLib.isGeoXPPointInGeoXPShape((long)location, (GeoXPLib.GeoXPShape)this.shape)) {
            return new Object[]{tick, location, elevation, null};
        }
        return new Object[]{tick, location, elevation, values[0]};
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(StackUtils.toString(GEOPACK.pack(this.shape)));
        }
        catch (WarpScriptException wse) {
            throw new RuntimeException(wse);
        }
        sb.append(" ");
        sb.append("GEOUNPACK");
        sb.append(" ");
        sb.append(this.getName());
        return sb.toString();
    }

    public static class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        public Builder(String name) {
            super(name);
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Object shape = stack.pop();
            if (!(shape instanceof GeoXPLib.GeoXPShape)) {
                throw new WarpScriptException(this.getName() + " expects a Geo Shape on top of the stack.");
            }
            stack.push(new MapperGeoOutside(this.getName(), (GeoXPLib.GeoXPShape)shape));
            return stack;
        }
    }
}

