/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.WarpConfig;
import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.store.Constants;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;

public class UPDATE
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private URL url = null;
    private boolean dynURL = false;

    public UPDATE(String name) {
        super(name);
    }

    public UPDATE(String name, URL url) {
        super(name);
        this.url = url;
    }

    public UPDATE(String name, boolean dynURL) {
        super(name);
        this.dynURL = dynURL;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object otoken = stack.pop();
        if (!(otoken instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a token on top of the stack.");
        }
        String token = (String)otoken;
        URL url = this.url;
        if (this.dynURL) {
            Object urlstr = stack.pop();
            try {
                url = new URL(urlstr.toString());
            }
            catch (MalformedURLException mue) {
                throw new WarpScriptException(mue);
            }
        }
        ArrayList<GeoTimeSerie> series = new ArrayList<GeoTimeSerie>();
        ArrayList<GTSEncoder> encoders = new ArrayList<GTSEncoder>();
        Object o = stack.pop();
        if (o instanceof GeoTimeSerie) {
            if (GTSHelper.nvalues((GeoTimeSerie)o) > 0) {
                series.add((GeoTimeSerie)o);
            }
        } else if (o instanceof GTSEncoder) {
            if (((GTSEncoder)o).getCount() > 0L) {
                encoders.add((GTSEncoder)o);
            }
        } else if (o instanceof List) {
            for (Object oo : (List)o) {
                if (oo instanceof GeoTimeSerie) {
                    if (GTSHelper.nvalues((GeoTimeSerie)oo) <= 0) continue;
                    series.add((GeoTimeSerie)oo);
                    continue;
                }
                if (oo instanceof GTSEncoder) {
                    if (((GTSEncoder)oo).getCount() <= 0L) continue;
                    encoders.add((GTSEncoder)oo);
                    continue;
                }
                throw new WarpScriptException(this.getName() + " can only operate on Geo Time Series, encoders or a list thereof.");
            }
        } else {
            throw new WarpScriptException(this.getName() + " can only operate on Geo Time Series, encoders or a list thereof.");
        }
        if (0 == series.size() && 0 == encoders.size()) {
            return stack;
        }
        for (GeoTimeSerie gts : series) {
            if (null == gts.getName() || "".equals(gts.getName())) {
                throw new WarpScriptException(this.getName() + " can only update Geo Time Series which have a non empty name.");
            }
            if (gts.isRenamed()) continue;
            throw new WarpScriptException(this.getName() + " can only update Geo Time Series which have been renamed.");
        }
        for (GTSEncoder encoder : encoders) {
            if (null != encoder.getName() && !"".equals(encoder.getName())) continue;
            throw new WarpScriptException(this.getName() + " can only update encoders which have a non empty name.");
        }
        HttpURLConnection conn = null;
        try {
            if (null == url) {
                String url_property = WarpConfig.getProperty("warpscript.update.endpoint");
                if (null != url_property) {
                    try {
                        url = this.url = new URL(url_property);
                    }
                    catch (MalformedURLException mue) {
                        throw new WarpScriptException(this.getName() + " configuration parameter '" + "warpscript.update.endpoint" + "' does not define a valid URL.");
                    }
                } else {
                    throw new WarpScriptException(this.getName() + " configuration parameter '" + "warpscript.update.endpoint" + "' not set.");
                }
            }
            conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty(Constants.getHeader("http.header.token.UPDATE"), token);
            conn.setRequestProperty("Content-Type", "application/gzip");
            String accel = "";
            if (null != stack.getAttribute("accel.nocache")) {
                boolean nocache = Boolean.TRUE.equals(stack.getAttribute("accel.nocache"));
                accel = nocache ? accel + "nocache" + " " : accel + "cache" + " ";
            }
            if (null != stack.getAttribute("accel.nopersist")) {
                boolean nopersist = Boolean.TRUE.equals(stack.getAttribute("accel.nopersist"));
                accel = nopersist ? accel + "nopersist" : accel + "persist";
            }
            if (!"".equals(accel)) {
                conn.setRequestProperty("X-Warp10-Accelerator", accel);
            }
            conn.setChunkedStreamingMode(16384);
            conn.connect();
            OutputStream os = conn.getOutputStream();
            GZIPOutputStream out = new GZIPOutputStream(os);
            PrintWriter pw = new PrintWriter(out);
            for (GeoTimeSerie gts : series) {
                gts.dump(pw);
            }
            for (GTSEncoder encoder : encoders) {
                GTSHelper.dump(encoder, pw);
                stack.handleSignal();
            }
            pw.close();
            if (200 != conn.getResponseCode()) {
                throw new WarpScriptException(this.getName() + " failed to complete successfully (" + conn.getResponseMessage() + ")");
            }
            conn.disconnect();
            conn = null;
        }
        catch (IOException ioe) {
            throw new WarpScriptException(this.getName() + " failed.", ioe);
        }
        finally {
            if (null != conn) {
                conn.disconnect();
            }
        }
        return stack;
    }
}

