/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.List;

public class SUBLIST
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public SUBLIST(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        List indices = null;
        List elements = null;
        ArrayList<Long> longParams = new ArrayList<Long>();
        for (int i = 0; i < 4; ++i) {
            Object o = stack.pop();
            if (o instanceof List) {
                if (0 == i) {
                    indices = (List)o;
                    o = stack.pop();
                    if (o instanceof List) {
                        elements = (List)o;
                        break;
                    }
                    throw new WarpScriptException(this.getName() + " expects a list of indices on top of the stack and will operate on the list below it.");
                }
                elements = (List)o;
                break;
            }
            if (!(o instanceof Number)) {
                throw new WarpScriptException(this.getName() + " expects a list of indices on top of the stack or a start end step and will operate on the list below it.");
            }
            longParams.add(0, ((Number)o).longValue());
        }
        if (null == elements) {
            throw new WarpScriptException(this.getName() + " expects a list of indices on top of the stack or a start end step and will operate on the list below it.");
        }
        int size = elements.size();
        ArrayList sublist = new ArrayList();
        if (null == indices) {
            long start = (Long)longParams.get(0);
            long end = longParams.size() > 1 ? (Long)longParams.get(1) : Math.max((long)(size - 1), start);
            if (start < 0L) {
                start += (long)size;
            }
            if (end < 0L) {
                end += (long)size;
            }
            if (!(start < 0L && end < 0L || start >= (long)size && end >= (long)size)) {
                long step = 1L;
                if (longParams.size() > 2) {
                    step = (Long)longParams.get(2);
                } else if (start > end) {
                    step = -1L;
                }
                if (0L == step) {
                    throw new WarpScriptException(this.getName() + " expects the step parameter to be a strictly positive or negative number.");
                }
                if (step > 0L) {
                    if (start > end) {
                        throw new WarpScriptException(this.getName() + " expects start to be before end when step is positive.");
                    }
                } else if (end > start) {
                    throw new WarpScriptException(this.getName() + " expects start to be after end when step is negative.");
                }
                start = SUBLIST.nearestValidBound(start, step, size);
                try {
                    if (step > 0L) {
                        end = Math.min(end, (long)(size - 1));
                        long i = start;
                        while (i <= end) {
                            sublist.add(elements.get(Math.toIntExact(i)));
                            i = Math.addExact(i, step);
                        }
                    }
                    end = Math.max(end, 0L);
                    long i = start;
                    while (i >= end) {
                        sublist.add(elements.get(Math.toIntExact(i)));
                        i = Math.addExact(i, step);
                    }
                }
                catch (ArithmeticException arithmeticException) {}
            }
        } else if (2 == indices.size()) {
            Object b0 = indices.get(0);
            Object b1 = indices.get(1);
            if (!(b0 instanceof Long) || !(b1 instanceof Long)) {
                throw new WarpScriptException(this.getName() + " expects a list of indices which are numeric integers.");
            }
            int bmin = ((Long)b0).intValue();
            int bmax = ((Long)b1).intValue();
            if (bmin < 0) {
                bmin = size + bmin;
            }
            if (bmax < 0) {
                bmax = size + bmax;
            }
            if (bmin > bmax) {
                int tmp = bmax;
                bmax = bmin;
                bmin = tmp;
            }
            if (!(bmin < 0 && bmax < 0 || size <= bmin && size <= bmax)) {
                bmin = Math.max(0, bmin);
                bmax = Math.min(size - 1, bmax);
                for (int i = bmin; i <= bmax; ++i) {
                    sublist.add(elements.get(i));
                }
            }
        } else {
            for (Object index : indices) {
                if (!(index instanceof Long)) {
                    throw new WarpScriptException(this.getName() + " expects a list of indices which are numeric integers.");
                }
                int idx = ((Long)index).intValue();
                if (idx >= size || idx < -1 * size) {
                    throw new WarpScriptException(this.getName() + " reported an out of bound index.");
                }
                if (idx >= 0) {
                    sublist.add(elements.get(idx));
                    continue;
                }
                sublist.add(elements.get(size + idx));
            }
        }
        stack.push(sublist);
        return stack;
    }

    private static long nearestValidBound(long bound, long step, int size) {
        if (bound >= (long)size) {
            return (bound - (long)size) % step - Math.abs(step) + (long)size;
        }
        if (bound < 0L) {
            return (bound + 1L) % step + Math.abs(step) - 1L;
        }
        return bound;
    }
}

