/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.store.Constants;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.warp.sdk.Capabilities;

public class RUNNERAT
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public RUNNERAT(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        long nowms;
        if (null == Capabilities.get(stack, "runner.reschedule.min.period")) {
            throw new WarpScriptException(this.getName() + " requires capability " + "runner.reschedule.min.period" + ".");
        }
        long minPeriod = Long.MAX_VALUE;
        try {
            minPeriod = Long.parseLong(Capabilities.get(stack, "runner.reschedule.min.period"));
        }
        catch (NumberFormatException e) {
            throw new WarpScriptException(this.getName() + " cannot parse capability " + "runner.reschedule.min.period" + ": '" + Capabilities.get(stack, "runner.reschedule.min.period") + "' is not a valid LONG");
        }
        if (minPeriod <= 0L) {
            throw new WarpScriptException(this.getName() + " requires capability " + "runner.reschedule.min.period" + " to be set to a value strictly greater than 0 ms.");
        }
        Object o = stack.pop();
        if (!(o instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a LONG timestamp as parameter.");
        }
        long progTs = (Long)o / Constants.TIME_UNITS_PER_MS;
        if (progTs < (nowms = System.currentTimeMillis()) + minPeriod) {
            throw new WarpScriptException(this.getName() + " cannot schedule a task before now + " + minPeriod + " ms defined in " + "runner.reschedule.min.period" + " capability.");
        }
        stack.setAttribute("runner.reschedule.timestamp", progTs);
        return stack;
    }
}

