/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.MemoryWarpScriptStack;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.ECVERIFY;
import io.warp10.script.functions.MSIG;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Hex;

public class MVERIFY
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final ECVERIFY ECVERIFY = new ECVERIFY("ECVERIFY");
    private final boolean verify;

    public MVERIFY(String name, boolean verify) {
        super(name);
        this.verify = verify;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof WarpScriptStack.Macro)) {
            throw new WarpScriptException(this.getName() + " operates on a macro.");
        }
        WarpScriptStack.Macro macro = (WarpScriptStack.Macro)top;
        boolean verified = MVERIFY.verify(macro);
        stack.push(macro);
        if (!this.verify) {
            stack.push(verified);
        } else if (!verified) {
            throw new WarpScriptException(this.getName() + " unable to verify macro.");
        }
        return stack;
    }

    public static boolean verify(WarpScriptStack.Macro macro) throws WarpScriptException {
        WarpScriptStack.Macro signature = MSIG.getSignature(macro);
        if (4 != signature.size()) {
            return false;
        }
        final ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)((String)signature.get(0)));
        ECCurve curve = spec.getCurve();
        final byte[] encoded = Hex.decode((String)((String)signature.get(1)));
        final ECPoint q = curve.decodePoint(encoded);
        ECPublicKey pubkey = new ECPublicKey(){

            public String getFormat() {
                return "PKCS#8";
            }

            public byte[] getEncoded() {
                return encoded;
            }

            public String getAlgorithm() {
                return "EC";
            }

            public ECParameterSpec getParameters() {
                return spec;
            }

            public ECPoint getQ() {
                return q;
            }
        };
        byte[] sig = Hex.decode((String)((String)signature.get(2)));
        WarpScriptStack.Macro m = new WarpScriptStack.Macro();
        for (int i = 0; i < macro.size() - signature.size(); ++i) {
            m.add(macro.get(i));
        }
        String snapshot = m.snapshot(false);
        byte[] data = snapshot.getBytes(StandardCharsets.UTF_8);
        MemoryWarpScriptStack stack = new MemoryWarpScriptStack(null, null);
        stack.push(data);
        stack.push(sig);
        stack.push("SHA256WITHECDSA");
        stack.push(pubkey);
        ECVERIFY.apply(stack);
        return Boolean.TRUE.equals(stack.pop());
    }
}

