/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class INDEXOF
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public INDEXOF(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        if (!(o instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a LONG number of indexes to return. 0 to return all indexes.");
        }
        long numberOfIndexes = (Long)o;
        if (numberOfIndexes <= 0L) {
            numberOfIndexes = Long.MAX_VALUE;
        }
        Object objectToLookFor = stack.pop();
        Object coll = stack.pop();
        ArrayList<Long> indexes = new ArrayList<Long>();
        if (coll instanceof List) {
            List list = (List)coll;
            for (int i = 0; i < list.size(); ++i) {
                Object element = list.get(i);
                if (!Objects.equals(objectToLookFor, element)) continue;
                indexes.add(Long.valueOf(i));
                if ((long)indexes.size() < numberOfIndexes) {
                    continue;
                }
                break;
            }
        } else if (coll instanceof Map) {
            Map map = (Map)coll;
            for (Map.Entry entry : map.entrySet()) {
                Object element = entry.getValue();
                if (!Objects.equals(objectToLookFor, element)) continue;
                indexes.add((Long)entry.getKey());
                if ((long)indexes.size() < numberOfIndexes) continue;
                break;
            }
        } else if (coll instanceof String) {
            if (!(objectToLookFor instanceof String)) {
                throw new WarpScriptException(this.getName() + " must be given a STRING to look for in a STRING");
            }
            String str = (String)coll;
            String strToLookFor = (String)objectToLookFor;
            for (int i = 0; i <= str.length() - strToLookFor.length(); ++i) {
                boolean equals = true;
                for (int j = 0; j < strToLookFor.length(); ++j) {
                    if (str.charAt(i + j) == strToLookFor.charAt(j)) continue;
                    equals = false;
                    break;
                }
                if (!equals) continue;
                indexes.add(Long.valueOf(i));
                if ((long)indexes.size() < numberOfIndexes) {
                    continue;
                }
                break;
            }
        } else if (coll instanceof GeoTimeSerie) {
            GeoTimeSerie gts = (GeoTimeSerie)coll;
            GeoTimeSerie.TYPE gtsType = gts.getType();
            if (gtsType == GeoTimeSerie.TYPE.LONG && objectToLookFor instanceof Double) {
                objectToLookFor = ((Number)objectToLookFor).longValue();
            } else if (gtsType == GeoTimeSerie.TYPE.DOUBLE && objectToLookFor instanceof Long) {
                objectToLookFor = ((Number)objectToLookFor).doubleValue();
            }
            if (gtsType == GeoTimeSerie.TYPE.BOOLEAN && objectToLookFor instanceof Boolean || gtsType == GeoTimeSerie.TYPE.LONG && objectToLookFor instanceof Long || gtsType == GeoTimeSerie.TYPE.DOUBLE && objectToLookFor instanceof Double || gtsType == GeoTimeSerie.TYPE.STRING && objectToLookFor instanceof String) {
                for (int i = 0; i < gts.size(); ++i) {
                    Object element = GTSHelper.valueAtIndex(gts, i);
                    if (!objectToLookFor.equals(element)) continue;
                    indexes.add(Long.valueOf(i));
                    if ((long)indexes.size() < numberOfIndexes) {
                        continue;
                    }
                    break;
                }
            }
        } else if (coll instanceof byte[]) {
            if (objectToLookFor instanceof Long) {
                if (!objectToLookFor.equals((Long)objectToLookFor & 0xFFL)) {
                    throw new WarpScriptException(this.getName() + " expects the LONG to look for to have only its least significant byte set when looking into BYTES.");
                }
                objectToLookFor = new byte[]{((Number)objectToLookFor).byteValue()};
            }
            if (!(objectToLookFor instanceof byte[])) {
                throw new WarpScriptException(this.getName() + " must be given a BYTES to look for in a BYTES.");
            }
            byte[] bytes = (byte[])coll;
            byte[] bytesToLookFor = (byte[])objectToLookFor;
            for (int i = 0; i <= bytes.length - bytesToLookFor.length; ++i) {
                boolean equals = true;
                for (int j = 0; j < bytesToLookFor.length; ++j) {
                    if (bytes[i + j] == bytesToLookFor[j]) continue;
                    equals = false;
                    break;
                }
                if (!equals) continue;
                indexes.add(Long.valueOf(i));
                if ((long)indexes.size() < numberOfIndexes) {
                    continue;
                }
                break;
            }
        } else {
            throw new WarpScriptException(this.getName() + " expects a LIST, MAP, STRING, GTS or BYTES.");
        }
        stack.push(indexes);
        return stack;
    }
}

