/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.geoxp.GeoXPLib;
import com.geoxp.geo.GeoHashHelper;
import com.geoxp.oss.jarjar.org.apache.commons.codec.binary.Hex;
import com.google.common.primitives.Longs;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.List;

public class GEOHASHTO
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public GEOHASHTO(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (top instanceof List) {
            List l = (List)top;
            ArrayList<String> geohashes = new ArrayList<String>(l.size());
            for (Object geohash : l) {
                if (!(geohash instanceof String)) {
                    throw new WarpScriptException(this.getName() + " expects a GeoHash to be a string.");
                }
                geohashes.add(geohash.toString().toLowerCase());
            }
            long[] geocells = GeoHashHelper.toGeoCells(geohashes);
            stack.push(GeoXPLib.fromCells((long[])geocells, (boolean)false));
        } else {
            Boolean toHHCodeString = null;
            if (top instanceof Boolean) {
                toHHCodeString = Boolean.TRUE.equals(top);
                top = stack.pop();
            }
            if (!(top instanceof String)) {
                throw new WarpScriptException(this.getName() + " expects a GeoHash to be a string.");
            }
            String geohash = top.toString().toLowerCase();
            long geoxppoint = GeoHashHelper.toHHCode((String)geohash);
            if (null != toHHCodeString) {
                if (Boolean.TRUE.equals(toHHCodeString)) {
                    stack.push(Hex.encodeHexString((byte[])Longs.toByteArray((long)geoxppoint)));
                } else {
                    stack.push(geoxppoint);
                }
            } else {
                double[] latlon = GeoXPLib.fromGeoXPPoint((long)geoxppoint);
                stack.push(latlon[0]);
                stack.push(latlon[1]);
            }
        }
        return stack;
    }
}

