/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.geoxp.oss.CryptoHelper;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.ECGEN;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Signature;
import java.security.SignatureException;
import org.bouncycastle.jce.interfaces.ECPrivateKey;

public class ECSIGN
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public ECSIGN(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof ECPrivateKey)) {
            throw new WarpScriptException(this.getName() + " expects an ECC private key.");
        }
        PrivateKey key = (PrivateKey)top;
        top = stack.pop();
        if (!(top instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects an algorithm name.");
        }
        String alg = (String)top;
        top = stack.pop();
        if (!(top instanceof byte[])) {
            throw new WarpScriptException(this.getName() + " operates on a byte array.");
        }
        byte[] data = (byte[])top;
        try {
            Signature signature = Signature.getInstance(alg, (Provider)ECGEN.BCProvider);
            signature.initSign(key, CryptoHelper.getSecureRandom());
            signature.update(data);
            stack.push(signature.sign());
        }
        catch (SignatureException se) {
            throw new WarpScriptException(this.getName() + " error signing content.", se);
        }
        catch (InvalidKeyException ike) {
            throw new WarpScriptException(this.getName() + " error signing content.", ike);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new WarpScriptException(this.getName() + " error signing content.", nsae);
        }
        return stack;
    }
}

