/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.ext.warprun;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;

public class FLOAD
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public FLOAD(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a file path.");
        }
        Path path = new Path((String)top);
        Configuration conf = new Configuration();
        conf.set("fs.hdfs.impl", DistributedFileSystem.class.getName());
        conf.set("fs.file.impl", LocalFileSystem.class.getName());
        FSDataInputStream in = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            FileSystem fs = path.getFileSystem(conf);
            in = fs.open(path);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            out.close();
            stack.push(out.toByteArray());
        }
        catch (IOException ioe) {
            throw new WarpScriptException(this.getName() + " error loading '" + path + "'.", ioe);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    throw new WarpScriptException(this.getName() + " error closing '" + path + "'.", e);
                }
            }
        }
        return stack;
    }
}

