/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.quasar.filter;

import com.google.common.base.Strings;
import io.warp10.crypto.KeyStore;
import io.warp10.crypto.OrderPreservingBase64;
import io.warp10.crypto.SipHashInline;
import io.warp10.quasar.encoder.QuasarTokenDecoder;
import io.warp10.quasar.filter.QuasarTokensRevoked;
import io.warp10.quasar.filter.exception.QuasarNoToken;
import io.warp10.quasar.filter.exception.QuasarTokenException;
import io.warp10.quasar.filter.exception.QuasarTokenExpired;
import io.warp10.quasar.token.thrift.data.ReadToken;
import io.warp10.quasar.token.thrift.data.WriteToken;
import io.warp10.quasar.trl.QuasarTokenRevocationListLoader;
import io.warp10.sensision.Sensision;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Properties;

public class QuasarTokenFilter {
    private final QuasarTokenDecoder quasarTokenDecoder;
    private final QuasarTokensRevoked quasarTokenRevoked;
    private Properties properties;
    private long tokenSipHashKeyK0;
    private long tokenSipHashKeyK1;

    private QuasarTokenFilter(Properties props, KeyStore keystore, String tokenAesKeyName) {
        this.properties = (Properties)props.clone();
        if (keystore == null) {
            throw new RuntimeException("keystore is null");
        }
        ByteBuffer bb = ByteBuffer.wrap(this.getKey(keystore, "warp.siphash.token"));
        bb.order(ByteOrder.BIG_ENDIAN);
        this.tokenSipHashKeyK0 = bb.getLong();
        this.tokenSipHashKeyK1 = bb.getLong();
        byte[] appSipHashKey = this.getKey(keystore, "warp.siphash.appid");
        byte[] tokenAESKey = this.getKey(keystore, tokenAesKeyName);
        this.quasarTokenDecoder = new QuasarTokenDecoder(this.tokenSipHashKeyK0, this.tokenSipHashKeyK1, tokenAESKey);
        this.quasarTokenRevoked = new QuasarTokensRevoked(this.properties, appSipHashKey);
    }

    public QuasarTokenFilter(Properties props, KeyStore keystore) {
        this(props, keystore, "warp.aes.token");
    }

    public ReadToken getReadToken(String cryptedToken) throws QuasarTokenException {
        long now = System.nanoTime();
        HashMap<String, String> labels = new HashMap<String, String>();
        try {
            labels.put("type", "READ");
            this.quasarTokenRevoked.available();
            if (Strings.isNullOrEmpty((String)cryptedToken)) {
                throw new QuasarNoToken("Read token missing.");
            }
            byte[] tokenB64Data = cryptedToken.getBytes();
            this.quasarTokenRevoked.isTokenRevoked(this.getTokenSipHash(tokenB64Data));
            byte[] tokenHexData = OrderPreservingBase64.decode(tokenB64Data);
            ReadToken token = this.quasarTokenDecoder.decodeReadToken(tokenHexData);
            long appId = QuasarTokenRevocationListLoader.getApplicationHash((String)token.getAppName());
            this.checkTokenExpired(token.getIssuanceTimestamp(), token.getExpiryTimestamp(), appId);
            this.quasarTokenRevoked.isRegisteredAppAuthorized(appId);
            ReadToken readToken = token;
            return readToken;
        }
        catch (QuasarTokenException qexp) {
            labels.put("error", qexp.label);
            throw qexp;
        }
        catch (Exception exp) {
            throw new QuasarTokenException("Read token unexpected error.", exp);
        }
        finally {
            long elapsedTimeUs = (System.nanoTime() - now) / 1000L;
            Sensision.update((String)"warp.quasar.filter.token.count", labels, (Number)1);
            Sensision.update((String)"warp.quasar.filter.token.time.us", labels, (Number)elapsedTimeUs);
        }
    }

    public boolean available() {
        return this.quasarTokenRevoked.loaded();
    }

    public WriteToken getWriteToken(String cryptedToken) throws QuasarTokenException {
        long now = System.nanoTime();
        HashMap<String, String> labels = new HashMap<String, String>();
        try {
            labels.put("type", "WRITE");
            this.quasarTokenRevoked.available();
            if (Strings.isNullOrEmpty((String)cryptedToken)) {
                throw new QuasarNoToken("Write token missing.");
            }
            byte[] tokenB64Data = cryptedToken.getBytes();
            this.quasarTokenRevoked.isTokenRevoked(this.getTokenSipHash(tokenB64Data));
            byte[] tokenHexData = OrderPreservingBase64.decode(tokenB64Data);
            WriteToken token = this.quasarTokenDecoder.decodeWriteToken(tokenHexData);
            long appId = QuasarTokenRevocationListLoader.getApplicationHash((String)token.getAppName());
            this.checkTokenExpired(token.getIssuanceTimestamp(), token.getExpiryTimestamp(), appId);
            this.quasarTokenRevoked.isRegisteredAppAuthorized(appId);
            WriteToken writeToken = token;
            return writeToken;
        }
        catch (QuasarTokenException qexp) {
            labels.put("error", qexp.label);
            throw qexp;
        }
        catch (Exception exp) {
            throw new QuasarTokenException("Write token unexpected error.", exp);
        }
        finally {
            long elapsedTimeUs = (System.nanoTime() - now) / 1000L;
            Sensision.update((String)"warp.quasar.filter.token.count", labels, (Number)1);
            Sensision.update((String)"warp.quasar.filter.token.time.us", labels, (Number)elapsedTimeUs);
        }
    }

    private byte[] getKey(KeyStore keystore, String name) {
        byte[] key = keystore.getKey(name);
        if (key == null) {
            throw new RuntimeException("key not found: " + name);
        }
        return key;
    }

    public long getTokenSipHash(byte[] nolookupToken) {
        return SipHashInline.hash24_palindromic(this.tokenSipHashKeyK0, this.tokenSipHashKeyK1, nolookupToken, 0, nolookupToken.length);
    }

    public void checkTokenExpired(long issuanceTimestamp, long expiryTimestamp, long clientId) throws QuasarTokenExpired {
        if (this.isExpired(issuanceTimestamp, expiryTimestamp, clientId)) {
            throw new QuasarTokenExpired("Token Expired.");
        }
    }

    private boolean isExpired(long issuanceTimestamp, long expiryTimestamp, long clientId) {
        if (expiryTimestamp < System.currentTimeMillis()) {
            return true;
        }
        Long endOfValidity = this.quasarTokenRevoked.getClientIdRefreshTimeStamp(clientId);
        return endOfValidity != null && issuanceTimestamp < endOfValidity;
    }

    public QuasarTokenDecoder getTokenDecoder() {
        return this.quasarTokenDecoder;
    }

    public QuasarTokensRevoked getTokensRevoked() {
        return this.quasarTokenRevoked;
    }
}

