/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.geoxp.GeoXPLib;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.store.thrift.data.Metadata;
import io.warp10.json.MetadataSerializer;
import java.io.IOException;

public class GeoTimeSerieSerializer
extends StdSerializer<GeoTimeSerie> {
    public static final String FIELD_VALUES = "v";

    protected GeoTimeSerieSerializer() {
        super(GeoTimeSerie.class);
    }

    public void serialize(GeoTimeSerie gts, JsonGenerator gen, SerializerProvider provider) throws IOException {
        Metadata metadata = gts.getMetadata();
        gen.writeStartObject();
        MetadataSerializer.serializeMetadataFields(metadata, gen);
        gen.writeFieldName(FIELD_VALUES);
        gen.writeStartArray(gts.size());
        for (int i = 0; i < gts.size(); ++i) {
            long ts = GTSHelper.tickAtIndex(gts, i);
            long location = GTSHelper.locationAtIndex(gts, i);
            long elevation = GTSHelper.elevationAtIndex(gts, i);
            Object v = GTSHelper.valueAtIndex(gts, i);
            gen.writeStartArray();
            gen.writeNumber(ts);
            if (91480763316633925L != location) {
                double[] latlon = GeoXPLib.fromGeoXPPoint((long)location);
                gen.writeNumber(latlon[0]);
                gen.writeNumber(latlon[1]);
            }
            if (Long.MIN_VALUE != elevation) {
                gen.writeNumber(elevation);
            }
            switch (gts.getType()) {
                case UNDEFINED: {
                    gen.writeObject(v);
                    break;
                }
                case LONG: {
                    gen.writeNumber(((Long)v).longValue());
                    break;
                }
                case DOUBLE: {
                    gen.writeNumber(((Double)v).doubleValue());
                    break;
                }
                case BOOLEAN: {
                    gen.writeBoolean(((Boolean)v).booleanValue());
                    break;
                }
                case STRING: {
                    gen.writeString((String)v);
                }
            }
            gen.writeEndArray();
        }
        gen.writeEndArray();
        gen.writeEndObject();
    }
}

