/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.continuum.gts;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.UnaryOperator;

public class ReadOnlyConstantList
implements List {
    private final int size;
    private final Object value;

    public ReadOnlyConstantList(int size, Object value) {
        this.value = value;
        this.size = size;
    }

    private void rangeCheck(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private String outOfBoundsMsg(int index) {
        return "Index: " + index + ", Size: " + this.size;
    }

    @Override
    public int indexOf(Object o) {
        if (o.equals(this.value) && this.size > 0) {
            return 0;
        }
        return -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            int cursor;

            @Override
            public boolean hasNext() {
                return this.cursor != ReadOnlyConstantList.this.size;
            }

            public Object next() {
                int i = this.cursor;
                if (i >= ReadOnlyConstantList.this.size) {
                    throw new NoSuchElementException();
                }
                Object res = ReadOnlyConstantList.this.value;
                this.cursor = i + 1;
                return res;
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public boolean add(Object o) {
        throw new RuntimeException("This is a read only list, cannot add element.");
    }

    @Override
    public boolean remove(Object o) {
        throw new RuntimeException("This is a read only list, cannot remove element.");
    }

    @Override
    public boolean addAll(Collection c) {
        throw new RuntimeException("This is a read only list, cannot add element.");
    }

    public boolean addAll(int index, Collection c) {
        throw new RuntimeException("This is a read only list, cannot add element.");
    }

    public void replaceAll(UnaryOperator operator) {
        throw new RuntimeException("This is a read only list, cannot overwrite element.");
    }

    public void sort(Comparator c) {
        throw new RuntimeException("This is a read only list, cannot sort elements.");
    }

    @Override
    public void clear() {
        throw new RuntimeException("This is a read only list, cannot remove elements.");
    }

    public Object get(int index) {
        this.rangeCheck(index);
        return this.value;
    }

    public Object set(int index, Object element) {
        throw new RuntimeException("This is a read only list, cannot overwrite element.");
    }

    public void add(int index, Object element) {
        throw new RuntimeException("This is a read only list, cannot overwrite element.");
    }

    public Object remove(int index) {
        throw new RuntimeException("This is a read only list, cannot remove element.");
    }

    @Override
    public int lastIndexOf(Object o) {
        if (this.size > 0 && o.equals(this.value)) {
            return this.size - 1;
        }
        return -1;
    }

    public ListIterator listIterator() {
        throw new RuntimeException("This is a read only list, cannot make a listIterator.");
    }

    public ListIterator listIterator(int index) {
        return null;
    }

    public List subList(int fromIndex, int toIndex) {
        this.rangeCheck(fromIndex);
        int subsize = toIndex - fromIndex;
        if (subsize < 0 || subsize + toIndex > this.size) {
            throw new IndexOutOfBoundsException("start index(" + fromIndex + ") + length(" + subsize + ") greater than original list size(" + this.size + "), cannot create sublist");
        }
        return new ReadOnlyConstantList(subsize, this.value);
    }

    @Override
    public Spliterator spliterator() {
        return List.super.spliterator();
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new RuntimeException("This is a read only list, cannot alter list content.");
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new RuntimeException("This is a read only list, cannot remove elements.");
    }

    @Override
    public boolean containsAll(Collection c) {
        throw new RuntimeException("This is a read only list, containsAll is not supported.");
    }

    @Override
    public Object[] toArray(Object[] a) {
        Object[] r = a;
        if (r.length < this.size) {
            r = new Object[this.size];
        }
        Arrays.fill(a, this.value);
        return r;
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size]);
    }
}

