/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.continuum;

import com.fasterxml.sort.DataReader;
import com.fasterxml.sort.DataReaderFactory;
import com.fasterxml.sort.DataWriterFactory;
import com.fasterxml.sort.SortConfig;
import com.fasterxml.sort.Sorter;
import com.fasterxml.sort.std.RawTextLineWriter;
import io.warp10.crypto.SipHashInline;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;

public class TextFileShuffler
extends Sorter<byte[]> {
    public TextFileShuffler() {
        this(new SortConfig());
    }

    public TextFileShuffler(SortConfig config) {
        super(config, new CustomReaderFactory(), (DataWriterFactory)RawTextLineWriter.factory(), (Comparator)new ShufflingComparator());
    }

    private static final class ShufflingComparator
    implements Comparator<byte[]> {
        private final long k0 = System.currentTimeMillis();
        private final long k1 = System.nanoTime();

        private ShufflingComparator() {
        }

        @Override
        public int compare(byte[] o1, byte[] o2) {
            long h1 = SipHashInline.hash24(this.k0, this.k1, o1, 0, o1.length);
            long h2 = SipHashInline.hash24(this.k0, this.k1, o2, 0, o2.length);
            return Long.compare(h1, h2);
        }
    }

    private static class CustomReaderFactory<T>
    extends DataReaderFactory<T> {
        private CustomReaderFactory() {
        }

        public DataReader<T> constructReader(InputStream in) throws IOException {
            return new CustomReader(in);
        }
    }

    public static class CustomReader<T>
    extends DataReader<T> {
        private final BufferedReader reader;

        public CustomReader(InputStream in) {
            this.reader = new BufferedReader(new InputStreamReader(in));
        }

        public T readNext() throws IOException {
            String line = this.reader.readLine();
            if (null == line) {
                return null;
            }
            return (T)line.getBytes(StandardCharsets.UTF_8);
        }

        public int estimateSizeInBytes(T item) {
            if (item instanceof byte[]) {
                return 24 + ((byte[])item).length;
            }
            return 24;
        }

        public void close() throws IOException {
            this.reader.close();
        }
    }
}

