//
//   Copyright 2018  SenX S.A.S.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//

package io.warp10.script.fwt.wavelets;

import io.warp10.script.fwt.Wavelet;

public class Wavelet_dmey extends Wavelet {

  private static final int transformWavelength = 2;

  private static final double[] scalingDeComposition = new double[] { 0.0, -1.009999956941423e-12, 8.519459636796214e-09, -1.111944952595278e-08, -1.0798819539621958e-08, 6.066975741351135e-08, -1.0866516536735883e-07, 8.200680650386481e-08, 1.1783004497663934e-07, -5.506340565252278e-07, 1.1307947017916706e-06, -1.489549216497156e-06, 7.367572885903746e-07, 3.20544191334478e-06, -1.6312699734552807e-05, 6.554305930575149e-05, -0.0006011502343516092, -0.002704672124643725, 0.002202534100911002, 0.006045814097323304, -0.006387718318497156, -0.011061496392513451, 0.015270015130934803, 0.017423434103729693, -0.03213079399021176, -0.024348745906078023, 0.0637390243228016, 0.030655091960824263, -0.13284520043622938, -0.035087555656258346, 0.44459300275757724, 0.7445855923188063, 0.44459300275757724, -0.035087555656258346, -0.13284520043622938, 0.030655091960824263, 0.0637390243228016, -0.024348745906078023, -0.03213079399021176, 0.017423434103729693, 0.015270015130934803, -0.011061496392513451, -0.006387718318497156, 0.006045814097323304, 0.002202534100911002, -0.002704672124643725, -0.0006011502343516092, 6.554305930575149e-05, -1.6312699734552807e-05, 3.20544191334478e-06, 7.367572885903746e-07, -1.489549216497156e-06, 1.1307947017916706e-06, -5.506340565252278e-07, 1.1783004497663934e-07, 8.200680650386481e-08, -1.0866516536735883e-07, 6.066975741351135e-08, -1.0798819539621958e-08, -1.111944952595278e-08, 8.519459636796214e-09, -1.009999956941423e-12,  };
  private static final double[] waveletDeComposition = new double[] { 1.009999956941423e-12, 8.519459636796214e-09, 1.111944952595278e-08, -1.0798819539621958e-08, -6.066975741351135e-08, -1.0866516536735883e-07, -8.200680650386481e-08, 1.1783004497663934e-07, 5.506340565252278e-07, 1.1307947017916706e-06, 1.489549216497156e-06, 7.367572885903746e-07, -3.20544191334478e-06, -1.6312699734552807e-05, -6.554305930575149e-05, -0.0006011502343516092, 0.002704672124643725, 0.002202534100911002, -0.006045814097323304, -0.006387718318497156, 0.011061496392513451, 0.015270015130934803, -0.017423434103729693, -0.03213079399021176, 0.024348745906078023, 0.0637390243228016, -0.030655091960824263, -0.13284520043622938, 0.035087555656258346, 0.44459300275757724, -0.7445855923188063, 0.44459300275757724, 0.035087555656258346, -0.13284520043622938, -0.030655091960824263, 0.0637390243228016, 0.024348745906078023, -0.03213079399021176, -0.017423434103729693, 0.015270015130934803, 0.011061496392513451, -0.006387718318497156, -0.006045814097323304, 0.002202534100911002, 0.002704672124643725, -0.0006011502343516092, -6.554305930575149e-05, -1.6312699734552807e-05, -3.20544191334478e-06, 7.367572885903746e-07, 1.489549216497156e-06, 1.1307947017916706e-06, 5.506340565252278e-07, 1.1783004497663934e-07, -8.200680650386481e-08, -1.0866516536735883e-07, -6.066975741351135e-08, -1.0798819539621958e-08, 1.111944952595278e-08, 8.519459636796214e-09, 1.009999956941423e-12, 0.0,  };

  private static final double[] scalingReConstruction = new double[] { -1.009999956941423e-12, 8.519459636796214e-09, -1.111944952595278e-08, -1.0798819539621958e-08, 6.066975741351135e-08, -1.0866516536735883e-07, 8.200680650386481e-08, 1.1783004497663934e-07, -5.506340565252278e-07, 1.1307947017916706e-06, -1.489549216497156e-06, 7.367572885903746e-07, 3.20544191334478e-06, -1.6312699734552807e-05, 6.554305930575149e-05, -0.0006011502343516092, -0.002704672124643725, 0.002202534100911002, 0.006045814097323304, -0.006387718318497156, -0.011061496392513451, 0.015270015130934803, 0.017423434103729693, -0.03213079399021176, -0.024348745906078023, 0.0637390243228016, 0.030655091960824263, -0.13284520043622938, -0.035087555656258346, 0.44459300275757724, 0.7445855923188063, 0.44459300275757724, -0.035087555656258346, -0.13284520043622938, 0.030655091960824263, 0.0637390243228016, -0.024348745906078023, -0.03213079399021176, 0.017423434103729693, 0.015270015130934803, -0.011061496392513451, -0.006387718318497156, 0.006045814097323304, 0.002202534100911002, -0.002704672124643725, -0.0006011502343516092, 6.554305930575149e-05, -1.6312699734552807e-05, 3.20544191334478e-06, 7.367572885903746e-07, -1.489549216497156e-06, 1.1307947017916706e-06, -5.506340565252278e-07, 1.1783004497663934e-07, 8.200680650386481e-08, -1.0866516536735883e-07, 6.066975741351135e-08, -1.0798819539621958e-08, -1.111944952595278e-08, 8.519459636796214e-09, -1.009999956941423e-12, 0.0,  };
  private static final double[] waveletReConstruction = new double[] { 0.0, 1.009999956941423e-12, 8.519459636796214e-09, 1.111944952595278e-08, -1.0798819539621958e-08, -6.066975741351135e-08, -1.0866516536735883e-07, -8.200680650386481e-08, 1.1783004497663934e-07, 5.506340565252278e-07, 1.1307947017916706e-06, 1.489549216497156e-06, 7.367572885903746e-07, -3.20544191334478e-06, -1.6312699734552807e-05, -6.554305930575149e-05, -0.0006011502343516092, 0.002704672124643725, 0.002202534100911002, -0.006045814097323304, -0.006387718318497156, 0.011061496392513451, 0.015270015130934803, -0.017423434103729693, -0.03213079399021176, 0.024348745906078023, 0.0637390243228016, -0.030655091960824263, -0.13284520043622938, 0.035087555656258346, 0.44459300275757724, -0.7445855923188063, 0.44459300275757724, 0.035087555656258346, -0.13284520043622938, -0.030655091960824263, 0.0637390243228016, 0.024348745906078023, -0.03213079399021176, -0.017423434103729693, 0.015270015130934803, 0.011061496392513451, -0.006387718318497156, -0.006045814097323304, 0.002202534100911002, 0.002704672124643725, -0.0006011502343516092, -6.554305930575149e-05, -1.6312699734552807e-05, -3.20544191334478e-06, 7.367572885903746e-07, 1.489549216497156e-06, 1.1307947017916706e-06, 5.506340565252278e-07, 1.1783004497663934e-07, -8.200680650386481e-08, -1.0866516536735883e-07, -6.066975741351135e-08, -1.0798819539621958e-08, 1.111944952595278e-08, 8.519459636796214e-09, 1.009999956941423e-12,  };

  static {
    //
    // Reverse the arrays as we do convolutions
    //
    reverse(scalingDeComposition);
    reverse(waveletDeComposition);
  }

  private static final void reverse(double[] array) {
    int i = 0;
    int j = array.length - 1;
    
    while (i < j) {
      double tmp = array[i];
      array[i] = array[j];
      array[j] = tmp;
      i++;
      j--;
    }
  }

  public int getTransformWavelength() {
    return transformWavelength;
  }

  public int getMotherWavelength() {
    return waveletReConstruction.length;
  }

  public double[] getScalingDeComposition() {
    return scalingDeComposition;
  }

  public double[] getWaveletDeComposition() {
    return waveletDeComposition;
  }

  public double[] getScalingReConstruction() {
    return scalingReConstruction;
  }

  public double[] getWaveletReConstruction() {
    return waveletReConstruction;
  }
}

