/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.unary;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;

public class TOLONG
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public TOLONG(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object op = stack.pop();
        if (op instanceof Number) {
            stack.push(((Number)op).longValue());
        } else if (op instanceof Boolean) {
            if (Boolean.TRUE.equals(op)) {
                stack.push(1L);
            } else {
                stack.push(0L);
            }
        } else if (op instanceof String) {
            stack.push(Long.decode(op.toString().trim()));
        } else if (op instanceof byte[]) {
            byte[] bytes = (byte[])op;
            if (bytes.length > 8) {
                throw new WarpScriptException(this.getName() + " can only operate on byte arrays from 1 to 8 bytes.");
            }
            long v = 0L;
            for (byte b : bytes) {
                v <<= 8;
                v |= (long)b & 0xFFL;
            }
            v <<= 64 - 8 * bytes.length;
            stack.push(v >>= 64 - 8 * bytes.length);
        } else {
            throw new WarpScriptException(this.getName() + " can only operate on numeric, boolean, byte array or string values.");
        }
        return stack;
    }
}

