/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.processing.image;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.processing.ProcessingUtil;
import java.util.List;
import processing.core.PGraphics;
import processing.core.PImage;

public class PupdatePixels
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public PupdatePixels(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        if (stack.depth() >= 2) {
            stack.push(1);
            Object level1 = stack.peekn();
            if (!(level1 instanceof PGraphics) && level1 instanceof PImage && stack.peek() instanceof List) {
                List pixels = (List)stack.pop();
                PImage pimg = (PImage)stack.peek();
                pimg.loadPixels();
                if (pimg.pixels.length != pixels.size()) {
                    throw new WarpScriptException(this.getName() + " expected array of " + pimg.pixels.length + " pixels, found " + pixels.size());
                }
                for (int i = 0; i < pimg.pixels.length; ++i) {
                    if (!(pixels.get(i) instanceof Long)) {
                        throw new WarpScriptException(this.getName() + " expected an array of LONG.");
                    }
                    pimg.pixels[i] = ((Long)pixels.get(i)).intValue();
                }
                pimg.updatePixels();
                return stack;
            }
        }
        List<Object> params = ProcessingUtil.parseParams(stack, 1);
        PGraphics pg = (PGraphics)params.get(0);
        if (!(params.get(1) instanceof List)) {
            throw new WarpScriptException(this.getName() + " expects an array of pixels on top of the stack.");
        }
        List pixels = (List)params.get(1);
        pg.parent.loadPixels();
        if (pixels.size() != pg.pixels.length) {
            throw new WarpScriptException(this.getName() + " expected an array of " + pg.pixels.length + " pixels, found " + pixels.size());
        }
        for (int i = 0; i < pg.pixels.length; ++i) {
            if (!(pixels.get(i) instanceof Long)) {
                throw new WarpScriptException(this.getName() + " expected an array of LONG.");
            }
            pg.pixels[i] = ((Long)pixels.get(i)).intValue();
        }
        pg.parent.updatePixels();
        stack.push(pg);
        return stack;
    }
}

