/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.processing;

import com.sun.imageio.plugins.png.PNGMetadata;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import org.apache.commons.codec.binary.Base64;
import processing.core.PGraphics;
import processing.core.PImage;

public class Pencode
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public Pencode(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        String imageStr;
        Object top = stack.pop();
        Map chunks = null;
        if (top instanceof Map) {
            chunks = (Map)top;
            top = stack.pop();
        }
        if (!(top instanceof PImage)) {
            throw new WarpScriptException(this.getName() + " operates on a " + "PGRAPHICS" + " or " + "PIMAGE" + " instance.");
        }
        PImage image = (PImage)top;
        try {
            imageStr = Pencode.PImageToString(image, chunks);
        }
        catch (WarpScriptException wse) {
            throw new WarpScriptException(this.getName() + " failed.", wse);
        }
        stack.push(imageStr);
        return stack;
    }

    public static String PImageToString(PImage image, Map<Object, Object> chunks) throws WarpScriptException {
        PGraphics pg = null;
        if (image instanceof PGraphics) {
            pg = (PGraphics)image;
            pg.endDraw();
        }
        BufferedImage bimage = new BufferedImage(image.pixelWidth, image.pixelHeight, 2);
        bimage.setRGB(0, 0, image.pixelWidth, image.pixelHeight, image.pixels, 0, image.pixelWidth);
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("png");
        ImageWriter writer = null;
        if (iter.hasNext()) {
            writer = iter.next();
        }
        ImageWriteParam param = writer.getDefaultWriteParam();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream output = new BufferedOutputStream(baos);
        try {
            writer.setOutput(ImageIO.createImageOutputStream(output));
            IIOImage iioimage = new IIOImage(bimage, null, null);
            if (null != chunks) {
                PNGMetadata metadata = new PNGMetadata();
                for (Map.Entry<Object, Object> entry : chunks.entrySet()) {
                    if ("tEXt".equals(entry.getKey()) || "zTXt".equals(entry.getKey())) {
                        boolean zTXt = "zTXt".equals(entry.getKey());
                        Object chunklist = entry.getValue();
                        if (!(chunklist instanceof List)) {
                            throw new WarpScriptException("Chunk type must be associated with a list of chunks.");
                        }
                        for (Object chunkelt : (List)chunklist) {
                            if (!(chunkelt instanceof Map)) {
                                throw new WarpScriptException("tEXt and zTXt chunks must be MAP instances.");
                            }
                            Map chunkmap = (Map)chunkelt;
                            if (chunkmap.get("keyword") instanceof String && chunkmap.get("text") instanceof String) {
                                if (zTXt) {
                                    metadata.zTXt_keyword.add((String)chunkmap.get("keyword"));
                                    metadata.zTXt_text.add((String)chunkmap.get("text"));
                                    metadata.zTXt_compressionMethod.add(0);
                                    continue;
                                }
                                metadata.tEXt_keyword.add((String)chunkmap.get("keyword"));
                                metadata.tEXt_text.add((String)chunkmap.get("text"));
                                continue;
                            }
                            throw new WarpScriptException("tEXt and zTXt chunks MUST contains 'keyword' and 'text' entries of type STRING.");
                        }
                        continue;
                    }
                    if ("iTXt".equals(entry.getKey())) {
                        Object chunklist = entry.getValue();
                        if (!(chunklist instanceof List)) {
                            throw new WarpScriptException("Chunk type must be associated with a list of chunks.");
                        }
                        for (Object chunkelt : (List)chunklist) {
                            if (!(chunkelt instanceof Map)) {
                                throw new WarpScriptException("iTXt chunks must be MAP instances.");
                            }
                            Map chunkmap = (Map)chunkelt;
                            if (chunkmap.get("keyword") instanceof String && chunkmap.get("text") instanceof String) {
                                metadata.iTXt_keyword.add((String)chunkmap.get("keyword"));
                                metadata.iTXt_text.add((String)chunkmap.get("text"));
                                metadata.iTXt_compressionFlag.add(Boolean.TRUE.equals(chunkmap.get("compressionFlag")));
                                metadata.iTXt_compressionMethod.add(0);
                                metadata.iTXt_languageTag.add(chunkmap.getOrDefault("languageTag", "").toString());
                                metadata.iTXt_translatedKeyword.add(chunkmap.getOrDefault("translatedKeyword", "").toString());
                                continue;
                            }
                            throw new WarpScriptException("iTXt chunks MUST contains 'keyword' and 'text' entries of type STRING.");
                        }
                        continue;
                    }
                    throw new WarpScriptException("Only 'tEXt', 'zTXt' and 'iTXt' chunks can be specified.");
                }
                iioimage.setMetadata(metadata);
            }
            writer.write(null, iioimage, param);
        }
        catch (IOException ioe) {
            throw new WarpScriptException("Error while encoding PGraphics or PImage.", ioe);
        }
        writer.dispose();
        StringBuilder sb = new StringBuilder("data:image/png;base64,");
        sb.append(Base64.encodeBase64String((byte[])baos.toByteArray()));
        if (null != pg) {
            pg.beginDraw();
        }
        return sb.toString();
    }
}

