/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.mapper;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.SAXUtils;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptMapperFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.Map;

public class MapperSAX
extends NamedWarpScriptFunction
implements WarpScriptMapperFunction {
    private final int levels;

    public MapperSAX(String name, int alphabetSize) throws WarpScriptException {
        super(name);
        int levels = 1;
        if (0 == alphabetSize) {
            throw new WarpScriptException("Alphabet size MUST be a power of two.");
        }
        while (0 == (alphabetSize & 1)) {
            ++levels;
            alphabetSize >>>= 1;
        }
        if (0 != alphabetSize) {
            throw new WarpScriptException("Alphabet size MUST be a power of two.");
        }
        if (levels < 2 || levels > 16) {
            throw new WarpScriptException("Alphabet size MUST be a power of two between 2 and 2^16");
        }
        this.levels = levels;
    }

    @Override
    public Object apply(Object[] args) throws WarpScriptException {
        long tick = (Long)args[0];
        String[] names = (String[])args[1];
        Map[] labels = (Map[])args[2];
        long[] ticks = (long[])args[3];
        long[] locations = (long[])args[4];
        long[] elevations = (long[])args[5];
        Object[] values = (Object[])args[6];
        if (0 == values.length) {
            return new Object[]{0L, 91480763316633925L, Long.MIN_VALUE, null};
        }
        if (1 != values.length) {
            throw new WarpScriptException(this.getName() + " can only be applied to a single value.");
        }
        if (!(values[0] instanceof Number)) {
            throw new WarpScriptException(this.getName() + " can only be applied to numeric values.");
        }
        return new Object[]{tick, locations[0], elevations[0], (long)SAXUtils.SAX(this.levels, ((Number)values[0]).doubleValue())};
    }

    public static class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        public Builder(String name) {
            super(name);
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Object value = stack.pop();
            if (!(value instanceof Number)) {
                throw new WarpScriptException("Invalid parameter for " + this.getName());
            }
            stack.push(new MapperSAX(this.getName(), ((Number)value).intValue()));
            return stack;
        }
    }
}

