/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.mapper;

import io.warp10.script.StackUtils;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.mapper.MapperDotProduct;

public class MapperDotProductPositive
extends MapperDotProduct {
    public MapperDotProductPositive(String name, double[] omega) {
        super(name, omega);
    }

    @Override
    public Object apply(Object[] args) throws WarpScriptException {
        Object[] result = (Object[])super.apply(args);
        if (null != result[3]) {
            result[3] = Math.max(0.0, (Double)result[3]);
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(" ");
        for (double d : this.getOmega()) {
            sb.append(StackUtils.toString(d));
            sb.append(" ");
        }
        sb.append("]");
        sb.append(" ");
        sb.append(this.getName());
        return sb.toString();
    }

    public static class Builder
    extends MapperDotProduct.Builder {
        public Builder(String name) {
            super(name);
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            super.apply(stack);
            MapperDotProduct mdp = (MapperDotProduct)stack.pop();
            stack.push(new MapperDotProductPositive(this.getName(), mdp.getOmega()));
            return stack;
        }
    }
}

