/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Longs;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class TORLP
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public TORLP(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        try {
            stack.push(TORLP.encode(top));
        }
        catch (Exception e) {
            throw new WarpScriptException(this.getName() + " encountered an error while encoding RLP.", e);
        }
        return stack;
    }

    public static byte[] encode(Object o) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (o instanceof List) {
            long size = 0L;
            for (Object item : (List)o) {
                byte[] encoded = TORLP.encode(item);
                size += (long)encoded.length;
                out.write(encoded);
            }
            if (size <= 55L) {
                return Bytes.concat((byte[][])new byte[][]{{(byte)(192L + size)}, out.toByteArray()});
            }
            byte[] len = Longs.toByteArray((long)size);
            int idx = 0;
            while (0 == len[idx]) {
                ++idx;
            }
            return Bytes.concat((byte[][])new byte[][]{Bytes.concat((byte[][])new byte[][]{{(byte)(255 - idx)}, Arrays.copyOfRange(len, idx, 8)}), out.toByteArray()});
        }
        if (o instanceof byte[] || o instanceof String) {
            byte[] data = o instanceof String ? ((String)o).getBytes(StandardCharsets.UTF_8) : (byte[])o;
            if (1 == data.length && (data[0] & 0xFF) <= 127) {
                return data;
            }
            if (data.length <= 55) {
                return Bytes.concat((byte[][])new byte[][]{{(byte)(128 + data.length)}, data});
            }
            byte[] len = Longs.toByteArray((long)data.length);
            int idx = 0;
            while (0 == len[idx]) {
                ++idx;
            }
            return Bytes.concat((byte[][])new byte[][]{Bytes.concat((byte[][])new byte[][]{{(byte)(191 - idx)}, Arrays.copyOfRange(len, idx, 8)}), data});
        }
        if (o instanceof Long) {
            long l = (Long)o;
            if (0L == l) {
                return TORLP.encode(new byte[0]);
            }
            byte[] data = Longs.toByteArray((long)l);
            if (l > 0L) {
                int idx = 0;
                while (0 == data[idx]) {
                    ++idx;
                }
                data = Arrays.copyOfRange(data, idx, data.length);
            }
            return TORLP.encode(data);
        }
        throw new WarpScriptException("Invalid item type, only LIST, LONG, BYTES and STRING are supported.");
    }
}

