/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.geoxp.GeoXPLib;
import com.geoxp.geo.HHCodeHelper;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.HHCODEFUNC;
import java.util.List;
import java.util.TreeSet;

public class TOGEOSHAPE
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public TOGEOSHAPE(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof List)) {
            throw new WarpScriptException(this.getName() + " expects a " + "LIST" + " of " + "LONG" + "," + "STRING" + " or " + "BYTES" + " representing geocells.");
        }
        List cellList = (List)top;
        TreeSet<Long> geocells = new TreeSet<Long>();
        for (Object cell : cellList) {
            long geocell;
            if (cell instanceof Long) {
                geocell = (Long)cell;
            } else if (cell instanceof String || cell instanceof byte[]) {
                long[] hhAndRes;
                try {
                    hhAndRes = HHCODEFUNC.hhAndRes(cell);
                }
                catch (WarpScriptException wse) {
                    throw new WarpScriptException(this.getName() + " expects the given list to contain valid STRING or BYTES HHCodes.", wse);
                }
                long hh = hhAndRes[0];
                int res = (int)hhAndRes[1];
                geocell = HHCodeHelper.toGeoCell((long)hh, (int)res);
            } else {
                throw new WarpScriptException(this.getName() + " expects a " + "LIST" + " of " + "LONG" + "," + "STRING" + " or " + "BYTES" + " representing geocells.");
            }
            if (0L == geocell >>> 60) {
                throw new WarpScriptException(this.getName() + " expects geocells resolutions to be even and between 2 and 30, inclusive.");
            }
            geocells.add(geocell);
        }
        stack.push(GeoXPLib.fromCells(geocells));
        return stack;
    }
}

