/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptATCException;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EmptyStackException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SORTWITH
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public SORTWITH(String name) {
        super(name);
    }

    @Override
    public Object apply(final WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof WarpScriptStack.Macro)) {
            throw new WarpScriptException(this.getName() + " expects a macro on top of the stack.");
        }
        final WarpScriptStack.Macro macro = (WarpScriptStack.Macro)top;
        top = stack.pop();
        if (top instanceof List) {
            List list = (List)top;
            try {
                list.sort(new Comparator(){

                    public int compare(Object o1, Object o2) {
                        try {
                            stack.push(o1);
                            stack.push(o2);
                            stack.exec(macro);
                            Object topComp = stack.pop();
                            if (!(topComp instanceof Long)) {
                                throw new WarpScriptException(SORTWITH.this.getName() + " was given a macro which doesn't return a LONG. This LONG must be within the bounds of a 32-bit integer.");
                            }
                            return Math.toIntExact((Long)topComp);
                        }
                        catch (WarpScriptException | ArithmeticException | EmptyStackException e) {
                            throw new ComparisonException(e);
                        }
                    }
                });
            }
            catch (ComparisonException ce) {
                if (ce.getCause() instanceof WarpScriptATCException) {
                    throw (WarpScriptATCException)ce.getCause();
                }
                throw new WarpScriptException(this.getName() + " encountered an error with comparator: " + ce.getCause().getMessage(), ce);
            }
            stack.push(list);
        } else if (top instanceof LinkedHashMap) {
            LinkedHashMap linkedHashMap = (LinkedHashMap)top;
            ArrayList entryList = new ArrayList(linkedHashMap.entrySet());
            try {
                entryList.sort(new Comparator<Map.Entry>(){

                    @Override
                    public int compare(Map.Entry entry1, Map.Entry entry2) {
                        try {
                            stack.push(entry1.getKey());
                            stack.push(entry1.getValue());
                            stack.push(entry2.getKey());
                            stack.push(entry2.getValue());
                            stack.exec(macro);
                            Object topComp = stack.pop();
                            if (!(topComp instanceof Long)) {
                                throw new WarpScriptException(SORTWITH.this.getName() + " was given a macro which doesn't return a LONG. This LONG must be within the bounds of a 32-bit integer.");
                            }
                            return Math.toIntExact((Long)topComp);
                        }
                        catch (WarpScriptException | ArithmeticException | EmptyStackException e) {
                            throw new ComparisonException(e);
                        }
                    }
                });
            }
            catch (ComparisonException ce) {
                throw new WarpScriptException(this.getName() + " encountered an error with comparator: " + ce.getCause().getMessage(), ce);
            }
            linkedHashMap.clear();
            for (Map.Entry entry : entryList) {
                linkedHashMap.put(entry.getKey(), entry.getValue());
            }
            stack.push(linkedHashMap);
        } else {
            throw new WarpScriptException(this.getName() + " operates on a list or a map created by {} or ->MAP.");
        }
        return stack;
    }

    private static class ComparisonException
    extends RuntimeException {
        public ComparisonException(Exception e) {
            super(e);
        }
    }
}

