/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.GTSStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import java.util.HashMap;
import java.util.Map;

public class SINGLEEXPONENTIALSMOOTHING
extends GTSStackFunction {
    private static final String ALPHA = "alpha";

    public SINGLEEXPONENTIALSMOOTHING(String name) {
        super(name);
    }

    @Override
    protected GeoTimeSerie gtsOp(Map<String, Object> params, GeoTimeSerie gts) throws WarpScriptException {
        return GTSHelper.singleExponentialSmoothing(gts, (Double)params.get(ALPHA));
    }

    @Override
    protected Map<String, Object> retrieveParameters(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof Number)) {
            throw new WarpScriptException(this.getName() + " expects the 'alpha' parameter (smoothing factor) on the top of the stack.");
        }
        double alpha = ((Number)top).doubleValue();
        if (alpha <= 0.0 || alpha >= 1.0) {
            throw new WarpScriptException("'alpha' (smoothing factor) should be strictly between 0.0 and 1.0.");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ALPHA, alpha);
        return params;
    }
}

