/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

public class RLPTO
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public RLPTO(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof byte[])) {
            throw new WarpScriptException(this.getName() + " operates on a byte array.");
        }
        try {
            stack.push(RLPTO.decode((byte[])top));
        }
        catch (Exception e) {
            throw new WarpScriptException(this.getName() + " encountered an error while decoding RLP.", e);
        }
        return stack;
    }

    public static Object decode(byte[] data) throws Exception {
        return RLPTO.decode(data, new AtomicInteger(0), data.length);
    }

    public static Object decode(byte[] data, AtomicInteger offset, int len) throws Exception {
        int idx = offset.get();
        if ((data[idx] & 0xFF) > 247) {
            int sizebytes = (data[idx] & 0xFF) - 247;
            ++idx;
            long size = 0L;
            if (sizebytes > 4) {
                throw new WarpScriptException("Unable to support size over 2**32.");
            }
            offset.addAndGet(1);
            while (sizebytes > 0) {
                size <<= 8;
                size |= (long)(data[idx++] & 0xFF);
                --sizebytes;
                offset.addAndGet(1);
            }
            int end = offset.get() + (int)size;
            ArrayList<Object> list = new ArrayList<Object>();
            while (offset.get() < end) {
                list.add(RLPTO.decode(data, offset, end - offset.get()));
            }
            return list;
        }
        if ((data[idx] & 0xFF) >= 192) {
            int size = (data[idx] & 0xFF) - 192;
            ArrayList<Object> list = new ArrayList<Object>();
            offset.addAndGet(1);
            int end = offset.get() + size;
            while (offset.get() < end) {
                list.add(RLPTO.decode(data, offset, end - offset.get()));
            }
            return list;
        }
        if ((data[idx] & 0xFF) > 183) {
            int sizebytes = (data[idx] & 0xFF) - 183;
            ++idx;
            long size = 0L;
            if (sizebytes > 4) {
                throw new WarpScriptException("Unable to support size over 2**32.");
            }
            offset.addAndGet(1);
            while (sizebytes > 0) {
                size <<= 8;
                size |= (long)(data[idx++] & 0xFF);
                --sizebytes;
                offset.addAndGet(1);
            }
            offset.addAndGet((int)size);
            return Arrays.copyOfRange(data, idx, idx + (int)size);
        }
        if ((data[idx] & 0xFF) >= 128) {
            int size = (data[idx] & 0xFF) - 128;
            offset.addAndGet(size + 1);
            return Arrays.copyOfRange(data, ++idx, idx + size);
        }
        offset.addAndGet(1);
        return Arrays.copyOfRange(data, idx, idx + 1);
    }
}

