/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.Collection;
import java.util.HashSet;

public class REMOVETICK
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public REMOVETICK(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof Long) && !(top instanceof Collection)) {
            throw new WarpScriptException(this.getName() + " expects a tick (LONG) or a collection thereof on top of the stack.");
        }
        HashSet<Long> ticks = new HashSet<Long>();
        if (top instanceof Long) {
            long tick = ((Number)top).longValue();
            ticks.add(tick);
        } else {
            for (Object o : (Collection)top) {
                if (!(o instanceof Long)) {
                    throw new WarpScriptException(this.getName() + " expects a tick (LONG) or a collection thereof on top of the stack.");
                }
                ticks.add(((Number)o).longValue());
            }
        }
        top = stack.pop();
        if (!(top instanceof GeoTimeSerie)) {
            throw new WarpScriptException(this.getName() + " operates on a Geo Time Series\u2122.");
        }
        GeoTimeSerie gts = (GeoTimeSerie)top;
        int n = GTSHelper.nvalues(gts);
        GeoTimeSerie pruned = gts.cloneEmpty(n);
        for (int i = 0; i < n; ++i) {
            long ts = GTSHelper.tickAtIndex(gts, i);
            if (ticks.contains(ts)) continue;
            GTSHelper.setValue(pruned, ts, GTSHelper.locationAtIndex(gts, i), GTSHelper.elevationAtIndex(gts, i), GTSHelper.valueAtIndex(gts, i), false);
        }
        stack.push(pruned);
        return stack;
    }
}

