/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import org.apache.commons.math3.distribution.NormalDistribution;

public class NBOUNDS
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public NBOUNDS(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a number of intervals on top of the stack.");
        }
        int n = ((Number)top).intValue();
        if (n < 1) {
            throw new WarpScriptException(this.getName() + " cannot generate bounds for less than 2 intervals.");
        }
        if (n > 65536) {
            throw new WarpScriptException(this.getName() + " cannot generate bounds for more than 65536 intervals.");
        }
        top = stack.pop();
        if (!(top instanceof Number)) {
            throw new WarpScriptException(this.getName() + " expects a standard deviation below the number of intervals.");
        }
        double sigma = ((Number)top).doubleValue();
        if (sigma <= 0.0) {
            throw new WarpScriptException(this.getName() + " expects a standard deviation strictly positive.");
        }
        top = stack.pop();
        if (!(top instanceof Number)) {
            throw new WarpScriptException(this.getName() + " expects a mean below the standard deviation.");
        }
        double mu = ((Number)top).doubleValue();
        NormalDistribution nd = new NormalDistribution(mu, sigma);
        ArrayList<Double> bounds = new ArrayList<Double>(n - 1);
        double area = 1.0 / (double)n;
        for (int i = 1; i <= n - 1; ++i) {
            bounds.add(nd.inverseCumulativeProbability((double)i * area));
        }
        stack.push(bounds);
        return stack;
    }
}

