/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptATCException;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptMapperFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MAP
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final String PARAM_MAPPER = "mapper";
    private static final String PARAM_PREWINDOW = "pre";
    private static final String PARAM_POSTWINDOW = "post";
    @Deprecated
    private static final String PARAM_OCCURENCES = "occurences";
    private static final String PARAM_OCCURRENCES = "occurrences";
    private static final String PARAM_STEP = "step";
    private static final String PARAM_OVERRIDE = "override";
    private static final String PARAM_OUTPUTTICKS = "ticks";

    public MAP(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (top instanceof Map) {
            return this.applyWithParamsFromMap(stack, (Map)top);
        }
        if (!(top instanceof List)) {
            throw new WarpScriptException(this.getName() + " expects a list as input or a map of parameters on top of a list of GTS.");
        }
        List params = (List)top;
        if (5 > params.size()) {
            throw new WarpScriptException(this.getName() + " needs a list of at least 5 parameters as input.");
        }
        int nseries = 0;
        for (Object param : params) {
            if (!(param instanceof GeoTimeSerie) && !(param instanceof List)) break;
            ++nseries;
        }
        if (0 == nseries) {
            throw new WarpScriptException(this.getName() + " expects Geo Time Series or lists thereof as first parameters.");
        }
        if (!(params.get(nseries) instanceof WarpScriptMapperFunction) && !(params.get(nseries) instanceof WarpScriptStack.Macro)) {
            throw new WarpScriptException(this.getName() + " expects a mapper function or a macro after Geo Time Series.");
        }
        if (!(params.get(nseries + 1) instanceof Long && params.get(nseries + 2) instanceof Long && params.get(nseries + 3) instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects prewindow, postwindow and occurrences as 3 parameters following the mapper function.");
        }
        int step = 1;
        if (params.size() > nseries + 4) {
            if (!(params.get(nseries + 4) instanceof Long)) {
                throw new WarpScriptException(this.getName() + " expects a step parameter that is an integer number.");
            }
            step = ((Number)params.get(nseries + 4)).intValue();
            if (step <= 0) {
                throw new WarpScriptException(this.getName() + " expects a step parameter which is strictly positive.");
            }
        }
        boolean overrideTick = false;
        if (params.size() > nseries + 5) {
            if (!(params.get(nseries + 5) instanceof Boolean)) {
                throw new WarpScriptException(this.getName() + " expects a boolean as 'override tick' parameter.");
            }
            overrideTick = Boolean.TRUE.equals(params.get(nseries + 5));
        }
        ArrayList series = new ArrayList();
        for (int i = 0; i < nseries; ++i) {
            series.add(params.get(i));
        }
        stack.push(series);
        HashMap<String, Object> mapParams = new HashMap<String, Object>();
        mapParams.put(PARAM_MAPPER, params.get(nseries));
        mapParams.put(PARAM_PREWINDOW, params.get(nseries + 1));
        mapParams.put(PARAM_POSTWINDOW, params.get(nseries + 2));
        mapParams.put(PARAM_OCCURRENCES, params.get(nseries + 3));
        mapParams.put(PARAM_STEP, Long.valueOf(step));
        mapParams.put(PARAM_OVERRIDE, overrideTick);
        return this.applyWithParamsFromMap(stack, mapParams);
    }

    private Object applyWithParamsFromMap(WarpScriptStack stack, Map params) throws WarpScriptException {
        Object stepParam;
        long prewindow = 0L;
        long postwindow = 0L;
        long occurrences = 0L;
        int step = 1;
        boolean overrideTick = false;
        if (!params.containsKey(PARAM_MAPPER)) {
            throw new WarpScriptException(this.getName() + " Missing '" + PARAM_MAPPER + "' parameter.");
        }
        Object mapper = params.get(PARAM_MAPPER);
        Object prewindowParam = params.get(PARAM_PREWINDOW);
        if (prewindowParam instanceof Long) {
            prewindow = (Long)prewindowParam;
        } else if (params.containsKey(PARAM_PREWINDOW)) {
            throw new WarpScriptException(this.getName() + " expects the " + PARAM_PREWINDOW + " parameter to be a LONG.");
        }
        Object postwindowParam = params.get(PARAM_POSTWINDOW);
        if (postwindowParam instanceof Long) {
            postwindow = (Long)postwindowParam;
        } else if (params.containsKey(PARAM_POSTWINDOW)) {
            throw new WarpScriptException(this.getName() + " expects the " + PARAM_POSTWINDOW + " parameter to be a LONG.");
        }
        Object occurencesParam = params.get(PARAM_OCCURENCES);
        if (occurencesParam instanceof Long) {
            occurrences = (Long)occurencesParam;
        } else if (params.containsKey(PARAM_OCCURENCES)) {
            throw new WarpScriptException(this.getName() + " expects the " + PARAM_OCCURENCES + " parameter to be a LONG.");
        }
        Object occurrencesParam = params.get(PARAM_OCCURRENCES);
        if (occurrencesParam instanceof Long) {
            occurrences = (Long)occurrencesParam;
        } else if (params.containsKey(PARAM_OCCURRENCES)) {
            throw new WarpScriptException(this.getName() + " expects the " + PARAM_OCCURRENCES + " parameter to be a LONG.");
        }
        if (Long.MIN_VALUE == occurrences) {
            occurrences = -9223372036854775807L;
        }
        if ((stepParam = params.get(PARAM_STEP)) instanceof Long) {
            step = (int)Math.min((Long)stepParam, Integer.MAX_VALUE);
        } else if (params.containsKey(PARAM_STEP)) {
            throw new WarpScriptException(this.getName() + " expects the " + PARAM_STEP + " parameter to be a LONG.");
        }
        Object overrideParam = params.get(PARAM_OVERRIDE);
        if (overrideParam instanceof Boolean) {
            overrideTick = (Boolean)overrideParam;
        } else if (params.containsKey(PARAM_OVERRIDE)) {
            throw new WarpScriptException(this.getName() + " expects the " + PARAM_OVERRIDE + " parameter to be a BOOLEAN.");
        }
        Object outputTicks = params.get(PARAM_OUTPUTTICKS);
        if (null != outputTicks) {
            if (!(outputTicks instanceof List)) {
                throw new WarpScriptException(this.getName() + " expects '" + PARAM_OUTPUTTICKS + "' to be list of LONG values.");
            }
            for (Object tick : (List)outputTicks) {
                if (tick instanceof Long) continue;
                throw new WarpScriptException(this.getName() + " expects '" + PARAM_OUTPUTTICKS + "' to be list of LONG values.");
            }
        }
        Object top = stack.pop();
        ArrayList<GeoTimeSerie> series = new ArrayList<GeoTimeSerie>();
        if (top instanceof List) {
            for (Object o : (List)top) {
                if (o instanceof List) {
                    for (Object oo : (List)o) {
                        if (!(oo instanceof GeoTimeSerie)) {
                            throw new WarpScriptException(this.getName() + " operates on lists of Geo Time Series.");
                        }
                        series.add((GeoTimeSerie)oo);
                    }
                    continue;
                }
                if (!(o instanceof GeoTimeSerie)) {
                    throw new WarpScriptException(this.getName() + " operates on lists of Geo Time Series.");
                }
                series.add((GeoTimeSerie)o);
            }
        } else {
            if (!(top instanceof GeoTimeSerie)) {
                throw new WarpScriptException(this.getName() + " operates on lists of Geo Time Series.");
            }
            series.add((GeoTimeSerie)top);
        }
        ArrayList<Object> mapped = new ArrayList<Object>();
        for (GeoTimeSerie gts : series) {
            List<GeoTimeSerie> res;
            try {
                res = GTSHelper.map(gts, mapper, prewindow, postwindow, Math.abs(occurrences), occurrences < 0L, step, overrideTick, mapper instanceof WarpScriptStack.Macro ? stack : null, (List)outputTicks);
            }
            catch (WarpScriptATCException wsatce) {
                throw wsatce;
            }
            catch (WarpScriptException wse) {
                throw new WarpScriptException(this.getName() + " was given invalid parameters.", wse);
            }
            if (res.size() < 2) {
                mapped.addAll(res);
                continue;
            }
            mapped.add(res);
        }
        stack.push(mapped);
        return stack;
    }
}

