/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptFilterFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MACROFILTER
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public MACROFILTER(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof WarpScriptStack.Macro)) {
            throw new WarpScriptException(this.getName() + " expects a macro on top of the stack.");
        }
        stack.push(new MacroFilterWrapper(this.getName(), stack, (WarpScriptStack.Macro)top));
        return stack;
    }

    public static class MacroFilterWrapper
    extends NamedWarpScriptFunction
    implements WarpScriptFilterFunction {
        private final WarpScriptStack stack;
        private final WarpScriptStack.Macro macro;

        public MacroFilterWrapper(String name, WarpScriptStack stack, WarpScriptStack.Macro macro) {
            super(name);
            this.stack = stack;
            this.macro = macro;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("<%");
            sb.append(" ");
            sb.append(this.macro.toString());
            sb.append(" ");
            sb.append(this.getName());
            sb.append(" ");
            sb.append("%>");
            sb.append(" ");
            sb.append("EVAL");
            return sb.toString();
        }

        @Override
        public List<GeoTimeSerie> filter(Map<String, String> labels, List<GeoTimeSerie> ... series) throws WarpScriptException {
            this.stack.push(labels);
            ArrayList<List<GeoTimeSerie>> lseries = new ArrayList<List<GeoTimeSerie>>();
            for (List<GeoTimeSerie> lserie : series) {
                lseries.add(lserie);
            }
            this.stack.push(lseries);
            this.stack.exec(this.macro);
            Object result = this.stack.pop();
            if (!(result instanceof List)) {
                throw new WarpScriptException(this.getName() + " macro should return a list of Geo Time Series onto the stack.");
            }
            return (List)result;
        }

        public WarpScriptStack.Macro getMacro() {
            return this.macro;
        }
    }
}

