/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.GTSStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import java.util.HashMap;
import java.util.Map;

public class LTTB
extends GTSStackFunction {
    private static final String THRESHOLD = "threshold";
    private final boolean timebased;

    public LTTB(String name, boolean timebased) {
        super(name);
        this.timebased = timebased;
    }

    @Override
    protected GeoTimeSerie gtsOp(Map<String, Object> params, GeoTimeSerie gts) throws WarpScriptException {
        int threshold = (Integer)params.get(THRESHOLD);
        return GTSHelper.lttb(gts, threshold, this.timebased);
    }

    @Override
    protected Map<String, Object> retrieveParameters(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a threshold on top of the stack.");
        }
        int threshold = ((Number)top).intValue();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(THRESHOLD, threshold);
        return params;
    }
}

