/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.store.Constants;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class ISO8601
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final DateTimeFormatter dtf = ISODateTimeFormat.dateTime();

    public ISO8601(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object obj = stack.peek();
        String tz = null;
        if (obj instanceof String) {
            tz = (String)obj;
            stack.pop();
        } else if (!(obj instanceof Long)) {
            throw new WarpScriptException(this.getName() + " operates on a timestamp or a timestamp + timezone.");
        }
        obj = stack.pop();
        if (!(obj instanceof Long)) {
            throw new WarpScriptException(this.getName() + " operates on a timestamp or a timestamp + timezone.");
        }
        long ts = (Long)obj;
        DateTimeFormatter dtf = null == tz ? this.dtf.withZoneUTC() : this.dtf.withZone(DateTimeZone.forID((String)tz));
        long millis = ts / Constants.TIME_UNITS_PER_MS;
        if (Constants.TIME_UNITS_PER_MS > 1L) {
            if (0L > ts && 0L != ts % Constants.TIME_UNITS_PER_MS) {
                --millis;
            }
            String dt = dtf.print(millis);
            StringBuilder sb = new StringBuilder();
            int millisIndex = dt.indexOf(46) + 4;
            sb.append(dt, 0, millisIndex);
            long subms = Constants.TIME_UNITS_PER_MS;
            String str = Long.toString(subms += Math.abs(ts - millis * Constants.TIME_UNITS_PER_MS));
            sb.append(str, 1, str.length());
            sb.append(dt, millisIndex, dt.length());
            stack.push(sb.toString());
        } else {
            String dt = dtf.print(millis);
            stack.push(dt);
        }
        return stack;
    }
}

