/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.geoxp.geo.HHCodeHelper;
import com.google.common.primitives.Longs;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.Arrays;

public class HHCODEFUNC
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final HHCodeAction action;

    public HHCODEFUNC(String name, HHCodeAction action) {
        super(name);
        this.action = action;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        long[] hhAndRes;
        Object top = stack.pop();
        int resOverride = -1;
        if (top instanceof Number) {
            resOverride = ((Number)top).intValue();
            if (resOverride < 2 || resOverride > 32 || 0 != (resOverride & 1)) {
                throw new WarpScriptException(this.getName() + " expects a resolution which is an even long between 2 and 32, inclusive.");
            }
            top = stack.pop();
        }
        try {
            hhAndRes = HHCODEFUNC.hhAndRes(top);
        }
        catch (WarpScriptException wse) {
            throw new WarpScriptException(this.getName() + " was given unexpected arguments.", wse);
        }
        long hh = hhAndRes[0];
        int res = (int)hhAndRes[1];
        if (resOverride >= 0) {
            res = resOverride;
        }
        switch (this.action) {
            case NORTH: {
                stack.push(HHCODEFUNC.manageFormat(HHCodeHelper.northHHCode((long)hh, (int)res), res, top));
                break;
            }
            case SOUTH: {
                stack.push(HHCODEFUNC.manageFormat(HHCodeHelper.southHHCode((long)hh, (int)res), res, top));
                break;
            }
            case EAST: {
                stack.push(HHCODEFUNC.manageFormat(HHCodeHelper.eastHHCode((long)hh, (int)res), res, top));
                break;
            }
            case WEST: {
                stack.push(HHCODEFUNC.manageFormat(HHCodeHelper.westHHCode((long)hh, (int)res), res, top));
                break;
            }
            case NORTH_EAST: {
                stack.push(HHCODEFUNC.manageFormat(HHCodeHelper.northEastHHCode((long)hh, (int)res), res, top));
                break;
            }
            case NORTH_WEST: {
                stack.push(HHCODEFUNC.manageFormat(HHCodeHelper.northWestHHCode((long)hh, (int)res), res, top));
                break;
            }
            case SOUTH_EAST: {
                stack.push(HHCODEFUNC.manageFormat(HHCodeHelper.southEastHHCode((long)hh, (int)res), res, top));
                break;
            }
            case SOUTH_WEST: {
                stack.push(HHCODEFUNC.manageFormat(HHCodeHelper.southWestHHCode((long)hh, (int)res), res, top));
                break;
            }
            case BBOX: {
                double[] bbox = HHCodeHelper.getHHCodeBBox((long)hh, (int)res);
                stack.push(bbox[0]);
                stack.push(bbox[1]);
                stack.push(bbox[2]);
                stack.push(bbox[3]);
                break;
            }
            case CENTER: {
                double[] latlon = HHCodeHelper.getCenterLatLon((long)hh, (int)res);
                stack.push(latlon[0]);
                stack.push(latlon[1]);
                break;
            }
            default: {
                throw new WarpScriptException("Unknown HHCODE action.");
            }
        }
        return stack;
    }

    private static Object manageFormat(long hh, int res, Object input) {
        Object o = input instanceof byte[] ? Longs.toByteArray((long)hh) : (input instanceof String ? (Object)HHCodeHelper.toString((long)hh, (int)res) : (Object)hh);
        return o;
    }

    public static long[] hhAndRes(Object hhcode) throws WarpScriptException {
        int res;
        long hh;
        if (hhcode instanceof Long) {
            hh = (Long)hhcode;
            res = 32;
        } else if (hhcode instanceof String) {
            String hhstr = hhcode.toString();
            res = hhstr.length() * 2;
            if (hhstr.length() > 16) {
                throw new WarpScriptException("Hexadecimal HHCode string of must be of length <= 16");
            }
            if (hhstr.length() < 16) {
                hhcode = new StringBuilder(hhstr).append("0000000000000000");
                ((StringBuilder)hhcode).setLength(16);
            }
            hh = Long.parseUnsignedLong(hhcode.toString(), 16);
        } else if (hhcode instanceof byte[]) {
            byte[] hhbytes = (byte[])hhcode;
            res = hhbytes.length * 4;
            if (hhbytes.length > 8) {
                throw new WarpScriptException("Byte array HHCode must be of length <= 8");
            }
            if (hhbytes.length < 8) {
                hhbytes = Arrays.copyOf(hhbytes, 8);
            }
            hh = Longs.fromByteArray((byte[])hhbytes);
        } else {
            throw new WarpScriptException("HHCode must be represented as a long, a string or a byte array.");
        }
        return new long[]{hh, res};
    }

    public static enum HHCodeAction {
        NORTH,
        SOUTH,
        EAST,
        WEST,
        NORTH_EAST,
        NORTH_WEST,
        SOUTH_EAST,
        SOUTH_WEST,
        BBOX,
        CENTER;

    }
}

