/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.operation.buffer.BufferOp;
import com.vividsolutions.jts.operation.buffer.BufferParameters;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.HashMap;
import java.util.Map;
import org.wololo.jts2geojson.GeoJSONReader;
import org.wololo.jts2geojson.GeoJSONWriter;

public class GEOBUFFER
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public static final String ATTR_GEOBUFFER = "geo.buffer";
    private static final double DEFAULT_DISTANCE = 8.999280057595392E-6;
    public static final String KEY_DIST = "dist";
    public static final String KEY_MDIST = "mdist";
    public static final String KEY_PARAMS = "params";
    private static final String KEY_CAP = "cap";
    private static final String KEY_JOIN = "join";
    private static final String KEY_SEGMENTS = "segments";
    private static final String KEY_LIMIT = "limit";
    public static final String KEY_WKB = "wkb";
    public static final String KEY_WKT = "wkt";
    public static final String KEY_GEOJSON = "geojson";
    public static final String KEY_SINGLESIDED = "singlesided";

    public GEOBUFFER(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof Map)) {
            throw new WarpScriptException(this.getName() + " expects a buffer definition map.");
        }
        Map map = (Map)top;
        HashMap<String, Double> buffer = new HashMap<String, Double>();
        double distance = 8.999280057595392E-6;
        if (map.containsKey(KEY_DIST)) {
            distance = Double.parseDouble(String.valueOf(map.get(KEY_DIST)));
        } else if (map.containsKey(KEY_MDIST)) {
            distance = Double.parseDouble(String.valueOf(map.get(KEY_MDIST)));
            distance *= 8.999280057595392E-6;
        }
        buffer.put(KEY_DIST, distance);
        int quadrantSegments = Integer.parseInt(String.valueOf(map.getOrDefault(KEY_SEGMENTS, 8)));
        int endCapStyle = 1;
        int joinStyle = 1;
        if (map.containsKey(KEY_CAP)) {
            String cap = String.valueOf(map.get(KEY_CAP));
            if ("SQUARE".equalsIgnoreCase(cap)) {
                endCapStyle = 3;
            } else if ("FLAT".equalsIgnoreCase(cap)) {
                endCapStyle = 2;
            } else if ("ROUND".equalsIgnoreCase(cap)) {
                endCapStyle = 1;
            }
        }
        if (map.containsKey(KEY_JOIN)) {
            String join = String.valueOf(map.get(KEY_JOIN));
            if ("BEVEL".equalsIgnoreCase(join)) {
                joinStyle = 3;
            } else if ("MITRE".equalsIgnoreCase(join)) {
                joinStyle = 2;
            } else if ("ROUND".equalsIgnoreCase(join)) {
                joinStyle = 1;
            }
        }
        double mitreLimit = 5.0;
        if (map.containsKey(KEY_LIMIT)) {
            mitreLimit = Double.parseDouble(String.valueOf(map.get(KEY_LIMIT)));
        }
        BufferParameters params = new BufferParameters(quadrantSegments, endCapStyle, joinStyle, mitreLimit);
        if (map.containsKey(KEY_SINGLESIDED)) {
            params.setSingleSided(Boolean.TRUE.equals(map.get(KEY_SINGLESIDED)));
        }
        if (map.get(KEY_WKB) instanceof byte[]) {
            if (map.containsKey(KEY_WKT) || map.containsKey(KEY_GEOJSON)) {
                throw new WarpScriptException(this.getName() + " only one of '" + KEY_WKB + "', '" + KEY_WKT + "' or '" + KEY_GEOJSON + "' can be specified.");
            }
            WKBReader reader = new WKBReader();
            Geometry geometry = null;
            try {
                byte[] bytes = (byte[])map.get(KEY_WKB);
                geometry = reader.read(bytes);
                BufferOp bop = new BufferOp(geometry, params);
                geometry = bop.getResultGeometry(distance);
                WKBWriter writer = new WKBWriter();
                stack.push(writer.write(geometry));
            }
            catch (ParseException pe) {
                throw new WarpScriptException(this.getName() + " expects valid WKB BYTES.", pe);
            }
        } else if (map.get(KEY_WKT) instanceof String) {
            if (map.containsKey(KEY_WKB) || map.containsKey(KEY_GEOJSON)) {
                throw new WarpScriptException(this.getName() + " only one of '" + KEY_WKB + "', '" + KEY_WKT + "' or '" + KEY_GEOJSON + "' can be specified.");
            }
            WKTReader reader = new WKTReader();
            Geometry geometry = null;
            try {
                geometry = reader.read(((String)map.get(KEY_WKT)).toString());
                BufferOp bop = new BufferOp(geometry, params);
                geometry = bop.getResultGeometry(distance);
                stack.push(geometry.toText());
            }
            catch (ParseException pe) {
                throw new WarpScriptException(this.getName() + " expects a valid WKT STRING.", pe);
            }
        } else if (map.get(KEY_GEOJSON) instanceof String) {
            if (map.containsKey(KEY_WKT) || map.containsKey(KEY_WKB)) {
                throw new WarpScriptException(this.getName() + " only one of '" + KEY_WKB + "', '" + KEY_WKT + "' or '" + KEY_GEOJSON + "' can be specified.");
            }
            GeoJSONReader reader = new GeoJSONReader();
            Geometry geometry = null;
            try {
                geometry = reader.read((String)map.get(KEY_GEOJSON));
                BufferOp bop = new BufferOp(geometry, params);
                geometry = bop.getResultGeometry(distance);
                GeoJSONWriter writer = new GeoJSONWriter();
                stack.push(writer.write(geometry).toString());
            }
            catch (UnsupportedOperationException uoe) {
                throw new WarpScriptException(this.getName() + " expects a valid GeoJSON STRING.", uoe);
            }
        } else {
            buffer.put(KEY_PARAMS, (Double)params);
            stack.setAttribute(ATTR_GEOBUFFER, buffer);
        }
        return stack;
    }
}

