/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptLoopBreakException;
import io.warp10.script.WarpScriptLoopContinueException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;

public class FORSTEP
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final long maxtime;

    public FORSTEP(String name) {
        super(name);
        this.maxtime = -1L;
    }

    public FORSTEP(String name, long maxtime) {
        super(name);
        this.maxtime = maxtime;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        long maxtime;
        Object top = stack.pop();
        boolean pushCounter = true;
        if (top instanceof Boolean) {
            pushCounter = (Boolean)top;
            top = stack.pop();
        }
        Object macroRun = top;
        Object macroStep = stack.pop();
        Object to = stack.pop();
        Object from = stack.pop();
        if (!(macroRun instanceof WarpScriptStack.Macro) || !(macroStep instanceof WarpScriptStack.Macro)) {
            throw new WarpScriptException(this.getName() + " expects two macros on top of the stack.");
        }
        if (!(to instanceof Number) || !(from instanceof Number)) {
            throw new WarpScriptException(this.getName() + " expects numbers as its range.");
        }
        double dfrom = 0.0;
        double dto = 0.0;
        double dcounter = 0.0;
        long lfrom = 0L;
        long lto = 0L;
        long lcounter = 0L;
        boolean useDouble = false;
        boolean ascending = true;
        if (from instanceof Double || to instanceof Double) {
            dfrom = ((Number)from).doubleValue();
            if (dfrom > (dto = ((Number)to).doubleValue())) {
                ascending = false;
            }
            dcounter = dfrom;
            useDouble = true;
        } else {
            lfrom = ((Number)from).longValue();
            if (lfrom > (lto = ((Number)to).longValue())) {
                ascending = false;
            }
            lcounter = lfrom;
        }
        long now = System.currentTimeMillis();
        long l = maxtime = this.maxtime > 0L ? this.maxtime : (Long)stack.getAttribute("loop.maxduration");
        while (true) {
            if (System.currentTimeMillis() - now > maxtime) {
                throw new WarpScriptException(this.getName() + " executed for too long (> " + maxtime + " ms).");
            }
            if (!useDouble ? ascending && lcounter > lto || !ascending && lcounter < lto : ascending && dcounter > dto || !ascending && dcounter < dto) break;
            if (pushCounter) {
                if (useDouble) {
                    stack.push(dcounter);
                } else {
                    stack.push(lcounter);
                }
            }
            try {
                stack.exec((WarpScriptStack.Macro)macroRun);
            }
            catch (WarpScriptLoopBreakException elbe) {
                break;
            }
            catch (WarpScriptLoopContinueException warpScriptLoopContinueException) {
                // empty catch block
            }
            if (useDouble) {
                stack.push(dcounter);
                stack.exec((WarpScriptStack.Macro)macroStep);
                dcounter = ((Number)stack.pop()).doubleValue();
                continue;
            }
            stack.push(lcounter);
            stack.exec((WarpScriptStack.Macro)macroStep);
            lcounter = ((Number)stack.pop()).longValue();
        }
        return stack;
    }
}

