/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.WarpDist;
import io.warp10.continuum.TimeSource;
import io.warp10.continuum.Tokens;
import io.warp10.continuum.egress.EgressFetchHandler;
import io.warp10.continuum.gts.GTSDecoder;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.gts.MetadataSelectorMatcher;
import io.warp10.continuum.store.Constants;
import io.warp10.continuum.store.MetadataIterator;
import io.warp10.continuum.store.thrift.data.DirectoryRequest;
import io.warp10.continuum.store.thrift.data.FetchRequest;
import io.warp10.continuum.store.thrift.data.MetaSet;
import io.warp10.continuum.store.thrift.data.Metadata;
import io.warp10.crypto.CryptoUtils;
import io.warp10.crypto.OrderPreservingBase64;
import io.warp10.crypto.SipHashInline;
import io.warp10.quasar.token.thrift.data.ReadToken;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.FIND;
import io.warp10.script.functions.LISTTO;
import io.warp10.script.functions.PARSESELECTOR;
import io.warp10.script.unary.TOTIMESTAMP;
import io.warp10.sensision.Sensision;
import io.warp10.standalone.AcceleratorConfig;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.MutablePeriod;
import org.joda.time.Period;
import org.joda.time.ReadWritablePeriod;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.joda.time.format.ISOPeriodFormat;

public class FETCH
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public static final String PARAM_CLASS = "class";
    public static final String PARAM_EXTRA = "extra";
    public static final String PARAM_LABELS = "labels";
    public static final String PARAM_SELECTOR = "selector";
    public static final String PARAM_SELECTORS = "selectors";
    public static final String PARAM_SELECTOR_PAIRS = "selpairs";
    public static final String PARAM_TOKEN = "token";
    public static final String PARAM_END = "end";
    public static final String PARAM_START = "start";
    public static final String PARAM_COUNT = "count";
    public static final String PARAM_TIMESPAN = "timespan";
    public static final String PARAM_TYPE = "type";
    public static final String PARAM_WRITE_TIMESTAMP = "wtimestamp";
    public static final String PARAM_TTL = "ttl";
    public static final String PARAM_SHOWUUID = "showuuid";
    public static final String PARAM_TYPEATTR = "typeattr";
    public static final String PARAM_METASET = "metaset";
    public static final String PARAM_GTS = "gts";
    public static final String PARAM_ACTIVE_AFTER = "active.after";
    public static final String PARAM_QUIET_AFTER = "quiet.after";
    public static final String PARAM_BOUNDARY_PRE = "boundary.pre";
    public static final String PARAM_BOUNDARY_POST = "boundary.post";
    public static final String PARAM_BOUNDARY = "boundary";
    public static final String PARAM_SKIP = "skip";
    public static final String PARAM_STEP = "step";
    public static final String PARAM_TIMESTEP = "timestep";
    public static final String PARAM_SAMPLE = "sample";
    public static final String PARAM_LABELS_PRIORITY = "priority";
    public static final String PARAM_ENCODERS = "encoders";
    public static final String PARAM_MERGE = "merge";
    public static final String POSTFETCH_HOOK = "postfetch";
    public static final String NOW_PARAM_VALUE = "now";
    private static DateTimeFormatter fmt = ISODateTimeFormat.dateTimeParser();
    private WarpScriptStackFunction listTo = new LISTTO("");
    private final GeoTimeSerie.TYPE forcedType;
    private long[] SIPHASH_CLASS;
    private long[] SIPHASH_LABELS;
    private byte[] AES_METASET;
    private boolean initialized = false;

    public FETCH(String name, GeoTimeSerie.TYPE type) {
        super(name);
        this.forcedType = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        block120: {
            block118: {
                block117: {
                    block122: {
                        block128: {
                            block127: {
                                block126: {
                                    block124: {
                                        block125: {
                                            block123: {
                                                block121: {
                                                    if (!this.initialized) {
                                                        var2_2 = FETCH.class;
                                                        // MONITORENTER : io.warp10.script.functions.FETCH.class
                                                        ks = null;
                                                        ks = WarpDist.getKeyStore();
                                                        if (null != ks) {
                                                            this.SIPHASH_CLASS = SipHashInline.getKey(ks.getKey("warp.siphash.class"));
                                                            this.SIPHASH_LABELS = SipHashInline.getKey(ks.getKey("warp.siphash.labels"));
                                                            this.AES_METASET = ks.getKey("warp.aes.metasets");
                                                        } else {
                                                            this.SIPHASH_CLASS = null;
                                                            this.SIPHASH_LABELS = null;
                                                            this.AES_METASET = null;
                                                        }
                                                        // MONITOREXIT : var2_2
                                                        this.initialized = true;
                                                    }
                                                    top = stack.pop();
                                                    params = null;
                                                    if (top instanceof Map) {
                                                        params = this.paramsFromMap((Map)top);
                                                    } else {
                                                        if (top instanceof List == false) throw new WarpScriptException(this.getName() + " expects a map or a list as parameter.");
                                                        list = (List)top;
                                                        if (5 != list.size()) {
                                                            throw new WarpScriptException(this.getName() + " expects a list with 5 elements.");
                                                        }
                                                        map = new HashMap<String, Object>();
                                                        map.put("token", list.get(0));
                                                        map.put("class", list.get(1));
                                                        map.put("labels", list.get(2));
                                                        if (list.get(3) instanceof Long && list.get(4) instanceof Long) {
                                                            map.put("end", list.get(3));
                                                            map.put("timespan", list.get(4));
                                                        } else {
                                                            if (list.get(3) instanceof String == false) throw new WarpScriptException(this.getName() + " expects '" + "start" + "' and '" + "end" + "' to be Strings or '" + "end" + "' and '" + "timespan" + "' to be Longs.");
                                                            if (list.get(4) instanceof String == false) throw new WarpScriptException(this.getName() + " expects '" + "start" + "' and '" + "end" + "' to be Strings or '" + "end" + "' and '" + "timespan" + "' to be Longs.");
                                                            map.put("start", list.get(3));
                                                            map.put("end", list.get(4));
                                                        }
                                                        params = this.paramsFromMap(map);
                                                    }
                                                    gtsStore = stack.getStoreClient();
                                                    directoryClient = stack.getDirectoryClient();
                                                    base = null;
                                                    bases = null;
                                                    typeattr = (String)params.get("typeattr");
                                                    if (null != typeattr) {
                                                        bases = new GeoTimeSerie[5];
                                                    }
                                                    try {
                                                        rtoken = Tokens.extractReadToken(params.get("token").toString());
                                                        rtokenAttributes = rtoken.getAttributes();
                                                        if (null != rtokenAttributes) {
                                                            if (rtokenAttributes.containsKey(".nofetch") != false) throw new WarpScriptException("Token cannot be used for fetching data.");
                                                            if (rtokenAttributes.containsKey(".nofind")) {
                                                                throw new WarpScriptException("Token cannot be used for fetching data.");
                                                            }
                                                        }
                                                    }
                                                    catch (WarpScriptException wse) {
                                                        throw new WarpScriptException(this.getName() + " given an invalid read token.", wse);
                                                    }
                                                    expose = rtoken.getAttributesSize() > 0 && rtoken.getAttributes().containsKey(".expose") != false;
                                                    merge = true;
                                                    if (Boolean.FALSE.equals(params.get("merge"))) {
                                                        merge = false;
                                                    }
                                                    asEncoders = false;
                                                    if (Boolean.TRUE.equals(params.get("encoders"))) {
                                                        asEncoders = true;
                                                    }
                                                    clsSels = new ArrayList<String>();
                                                    lblsSels = new ArrayList<Map<String, String>>();
                                                    metaset = null;
                                                    metadatas = null;
                                                    iter /* !! */  = null;
                                                    if (!params.containsKey("metaset")) break block121;
                                                    metaset = (MetaSet)params.get("metaset");
                                                    iter /* !! */  = metaset.getMetadatas().iterator();
                                                    break block122;
                                                }
                                                if (!params.containsKey("gts")) break block123;
                                                metas = (List)params.get("gts");
                                                tokenSelectors = Tokens.labelSelectorsFromReadToken(rtoken);
                                                singleApp = tokenSelectors.containsKey(".app") != false && '=' == tokenSelectors.get(".app").charAt(0);
                                                singleOwner = tokenSelectors.containsKey(".owner") != false && '=' == tokenSelectors.get(".owner").charAt(0);
                                                var22_29 = tokenSelectors.containsKey(".producer") != false && '=' == tokenSelectors.get(".producer").charAt(0);
                                                application = singleApp != false ? tokenSelectors.get(".app").substring(1) : null;
                                                var24_37 = singleOwner != false ? tokenSelectors.get(".owner").substring(1) : null;
                                                producer = var22_29 != false ? tokenSelectors.get(".producer").substring(1) : null;
                                                tmeta = new Metadata();
                                                tmeta.setName("");
                                                tmeta.setLabels(tokenSelectors);
                                                tselector = "~.*" + GTSHelper.buildSelector(tmeta, true);
                                                matcher = new MetadataSelectorMatcher(tselector);
                                                var29_48 = metas.iterator();
                                                break block124;
                                            }
                                            if (!params.containsKey("selpairs")) break block125;
                                            metas = ((List)params.get("selpairs")).iterator();
                                            break block126;
                                        }
                                        clsSels.add(params.get("class").toString());
                                        labelSelectors = (Map)params.get("labels");
                                        labelSelectors.remove(".producer");
                                        labelSelectors.remove(".owner");
                                        labelSelectors.remove(".app");
                                        labelSelectors.putAll(Tokens.labelSelectorsFromReadToken(rtoken));
                                        order = null;
                                        order = params.containsKey("priority") != false ? (List)params.get("priority") : FIND.DEFAULT_LABELS_PRIORITY;
                                        ordered = new LinkedHashMap<String, V>(labelSelectors.size());
                                        for (String var22_31 : order) {
                                            if (!labelSelectors.containsKey(var22_31)) continue;
                                            ordered.put(var22_31, labelSelectors.get(var22_31));
                                        }
                                        var21_28 = labelSelectors.entrySet().iterator();
                                        break block127;
                                    }
                                    while (var29_48.hasNext()) {
                                        m = (Metadata)var29_48.next();
                                        if (null == m.getLabels()) {
                                            m.setLabels(new LinkedHashMap<String, String>());
                                        }
                                        matches = false;
                                        if (m.getLabels().containsKey(".producer") && m.getLabels().containsKey(".owner") && m.getLabels().containsKey(".app")) {
                                            matches = matcher.matches(m);
                                        }
                                        if (!matches) {
                                            if (singleApp == false) throw new WarpScriptException(this.getName() + " provided token is incompatible with '" + "gts" + "' parameter, expecting a single application.");
                                            m.getLabels().put(".app", application);
                                            if (var22_29 && singleOwner) {
                                                m.getLabels().put(".producer", producer);
                                                m.getLabels().put(".owner", var24_37);
                                            } else if (var22_29 && !tokenSelectors.containsKey(".owner")) {
                                                m.getLabels().put(".producer", producer);
                                                m.getLabels().put(".owner", producer);
                                            } else {
                                                if (singleOwner == false) throw new WarpScriptException(this.getName() + " provided token is incompatible with '" + "gts" + "' parameter, expecting a single producer and/or single owner.");
                                                if (tokenSelectors.containsKey(".producer") != false) throw new WarpScriptException(this.getName() + " provided token is incompatible with '" + "gts" + "' parameter, expecting a single producer and/or single owner.");
                                                m.getLabels().put(".owner", var24_37);
                                                m.getLabels().put(".producer", var24_37);
                                            }
                                        }
                                        m.setClassId(GTSHelper.classId(this.SIPHASH_CLASS, m.getName()));
                                        m.setLabelsId(GTSHelper.labelsId(this.SIPHASH_LABELS, m.getLabels()));
                                    }
                                    iter /* !! */  = ((List)params.get("gts")).iterator();
                                    break block122;
                                }
                                while (metas.hasNext()) {
                                    pair = (Pair)metas.next();
                                    clsSels.add(pair.getLeft().toString());
                                    labelSelectors = (Map)pair.getRight();
                                    labelSelectors.remove(".producer");
                                    labelSelectors.remove(".owner");
                                    labelSelectors.remove(".app");
                                    labelSelectors.putAll(Tokens.labelSelectorsFromReadToken(rtoken));
                                    order = null;
                                    order = params.containsKey("priority") != false ? (List)params.get("priority") : FIND.DEFAULT_LABELS_PRIORITY;
                                    var22_30 = new LinkedHashMap<String, V>(labelSelectors.size());
                                    for (String var24_39 : order) {
                                        if (!labelSelectors.containsKey(var24_39)) continue;
                                        var22_30.put(var24_39, labelSelectors.get(var24_39));
                                    }
                                    for (Map.Entry var24_40 : labelSelectors.entrySet()) {
                                        if (order.contains(var24_40.getKey())) continue;
                                        var22_30.put((String)var24_40.getKey(), var24_40.getValue());
                                    }
                                    lblsSels.add(var22_30);
                                }
                                break block128;
                            }
                            while (var21_28.hasNext()) {
                                var22_33 = (Map.Entry)var21_28.next();
                                if (order.contains(var22_33.getKey())) continue;
                                ordered.put((String)var22_33.getKey(), var22_33.getValue());
                            }
                            lblsSels.add(ordered);
                        }
                        drequest = new DirectoryRequest();
                        drequest.setClassSelectors(clsSels);
                        drequest.setLabelsSelectors(lblsSels);
                        if (params.containsKey("active.after")) {
                            drequest.setActiveAfter((Long)params.get("active.after"));
                        }
                        if (params.containsKey("quiet.after")) {
                            drequest.setQuietAfter((Long)params.get("quiet.after"));
                        }
                        try {
                            metadatas = directoryClient.find(drequest);
                            iter /* !! */  = metadatas.iterator();
                        }
                        catch (IOException ioe) {
                            try {
                                iter /* !! */  = directoryClient.iterator(drequest);
                            }
                            catch (Exception e) {
                                throw new WarpScriptException(this.getName() + " failed.", e);
                            }
                        }
                    }
                    metadatas = new ArrayList<E>();
                    series = new ArrayList<Cloneable>();
                    fetched = (AtomicLong)stack.getAttribute("fetch.count");
                    fetchLimit = (Long)stack.getAttribute("fetch.limit");
                    var22_35 = (Long)stack.getAttribute("gts.limit");
                    var24_42 = (AtomicLong)stack.getAttribute("gts.count");
                    lastMetadata = null;
                    lastCount = 0L;
                    lastEncoder = null;
                    preBoundary = 0L;
                    postBoundary = 0L;
                    if (params.containsKey("boundary.pre")) {
                        preBoundary = (Long)params.get("boundary.pre");
                    }
                    if (params.containsKey("boundary.post")) {
                        postBoundary = (Long)params.get("boundary.post");
                    }
                    while (true) {
                        if (!iter /* !! */ .hasNext()) break;
                        metadatas.add(iter /* !! */ .next());
                        if (var24_42.incrementAndGet() > var22_35) {
                            throw new WarpScriptException(this.getName() + " exceeded limit of " + var22_35 + " Geo Time Series, current count is " + var24_42);
                        }
                        stack.handleSignal();
                        if ((long)metadatas.size() < EgressFetchHandler.FETCH_BATCHSIZE && iter /* !! */ .hasNext()) continue;
                        if (params.containsKey("extra")) {
                            withextra = new HashSet<Object>();
                            withextra.addAll(metadatas);
                            for (Metadata var35_59 : metadatas) {
                                for (String cls : (Set)params.get("extra")) {
                                    metadata = new Metadata(var35_59);
                                    metadata.setName(cls);
                                    metadata.setClassId(GTSHelper.classId(this.SIPHASH_CLASS, cls));
                                    metadata.setLabelsId(GTSHelper.labelsId(this.SIPHASH_LABELS, metadata.getLabels()));
                                    withextra.add(metadata);
                                }
                            }
                            metadatas.clear();
                            metadatas.addAll(withextra);
                        }
                        count = -1L;
                        if (params.containsKey("count")) {
                            count = (Long)params.get("count");
                        }
                        var35_58 = (Long)params.get("start");
                        skip = (Long)params.getOrDefault("skip", 0L);
                        timestep = 1L;
                        step = 1L;
                        if (params.containsKey("timestep")) {
                            timestep = (Long)params.get("timestep");
                        }
                        if (params.containsKey("step")) {
                            step = (Long)params.get("step");
                        }
                        sample = (Double)params.getOrDefault("sample", 1.0);
                        type = (GeoTimeSerie.TYPE)params.get("type");
                        if (null != this.forcedType) {
                            if (null != type) {
                                throw new WarpScriptException(this.getName() + " type of fetched GTS cannot be changed.");
                            }
                            type = this.forcedType;
                        }
                        writeTimestamp = Boolean.TRUE.equals(params.get("wtimestamp"));
                        ttl = Boolean.TRUE.equals(params.get("ttl"));
                        showUUID = Boolean.TRUE.equals(params.get("showuuid"));
                        lastType = GeoTimeSerie.TYPE.UNDEFINED;
                        end = (Long)params.get("end");
                        nocache = AcceleratorConfig.getDefaultReadNocache();
                        if (null != stack.getAttribute("accel.nocache")) {
                            nocache = Boolean.TRUE.equals(stack.getAttribute("accel.nocache"));
                        }
                        nopersist = AcceleratorConfig.getDefaultReadNopersist();
                        if (null != stack.getAttribute("accel.nopersist")) {
                            nopersist = Boolean.TRUE.equals(stack.getAttribute("accel.nopersist"));
                        }
                        if (nocache) {
                            AcceleratorConfig.nocache();
                        } else {
                            AcceleratorConfig.cache();
                        }
                        if (nopersist) {
                            AcceleratorConfig.nopersist();
                        } else {
                            AcceleratorConfig.persist();
                        }
                        countOnly = count >= 0L && 0L == preBoundary && 0L == postBoundary;
                        req = new FetchRequest();
                        req.setToken(rtoken);
                        req.setMetadatas(metadatas);
                        req.setNow(end);
                        req.setThents(var35_58);
                        req.setCount(count);
                        req.setSkip(skip);
                        req.setStep(step);
                        req.setTimestep(timestep);
                        req.setSample(sample);
                        req.setWriteTimestamp(writeTimestamp);
                        req.setTTL(ttl);
                        req.setPreBoundary(preBoundary);
                        req.setPostBoundary(postBoundary);
                        try {
                            gtsiter = gtsStore.fetch(req);
                            var57_80 = null;
                            ** try [egrp 6[TRYBLOCK] [6, 7 : 3241->4625)] { 
lbl334:
                            // 1 sources

                            break block117;
lbl335:
                            // 1 sources

                            catch (Throwable var58_83) {
                                var57_80 = var58_83;
                                throw var58_83;
                            }
                        }
                        catch (WarpScriptException ee) {
                            throw ee;
                        }
                        catch (Throwable t) {
                            throw new WarpScriptException(this.getName() + "failed.", t);
                        }
                        break;
                    }
                    stack.push(series);
                    if (rtoken.getHooksSize() <= 0) return stack;
                    if (rtoken.getHooks().containsKey("postfetch") == false) return stack;
                    stack.execMulti(rtoken.getHooks().get("postfetch"));
                    return stack;
                }
lbl351:
                // 2 sources

                while (true) {
                    if (!gtsiter.hasNext()) break block118;
                    decoder = (GTSDecoder)gtsiter.next();
                    if (asEncoders) {
                        decoder.next();
                        encoder = decoder.getEncoder(false);
                        if (showUUID) {
                            uuid = new UUID(encoder.getMetadata().getClassId(), encoder.getMetadata().getLabelsId());
                            encoder.getMetadata().putToAttributes(".uuid", uuid.toString());
                        }
                        labels = new LinkedHashMap<String, String>();
                        labels.putAll(encoder.getMetadata().getLabels());
                        if (!Constants.EXPOSE_OWNER_PRODUCER && !expose) {
                            labels.remove(".producer");
                            labels.remove(".owner");
                        }
                        encoder.setLabels(labels);
                        if (!encoder.getMetadata().equals(lastMetadata)) {
                            lastMetadata = encoder.getMetadata();
                            lastCount = 0L;
                        }
                        if (countOnly && lastCount + encoder.getCount() > count) {
                            decoder = encoder.getDecoder(true);
                            encoder = decoder.getCompatibleEncoder(encoder.getBaseTimestamp());
                            for (copy = count - lastCount; copy > 0L && decoder.next(); --copy) {
                                encoder.addValue(decoder.getTimestamp(), decoder.getLocation(), decoder.getElevation(), decoder.getBinaryValue());
                            }
                        }
                        lastCount += encoder.getCount();
                        if (merge) {
                            if (null == lastEncoder || !lastEncoder.getName().equals(encoder.getName()) || !lastEncoder.getLabels().equals(encoder.getLabels())) {
                                lastEncoder = encoder;
                                series.add(lastEncoder);
                            } else {
                                lastEncoder.merge(encoder);
                            }
                        } else {
                            series.add(encoder);
                        }
                        if (fetched.addAndGet(encoder.getCount()) <= fetchLimit) continue;
                        sensisionLabels = new HashMap<String, String>();
                        sensisionLabels.put("consumer", Tokens.getUUID(rtoken.getBilledId()));
                        Sensision.update((String)"warp.script.fetchcount.exceeded", sensisionLabels, (Number)1);
                        throw new WarpScriptException(this.getName() + " exceeded limit of " + fetchLimit + " datapoints, current count is " + fetched.get());
                    }
                    identical = true;
                    if (null == lastMetadata || !lastMetadata.equals(decoder.getMetadata())) {
                        lastMetadata = decoder.getMetadata();
                        identical = false;
                        lastCount = 0L;
                        lastType = GeoTimeSerie.TYPE.UNDEFINED;
                    }
                    if (null != typeattr) {
                        uuid = null;
                        if (showUUID) {
                            uuid = new UUID(decoder.getClassId(), decoder.getLabelsId());
                        }
                        dpcount = 0L;
                        decoderMeta = new Metadata(decoder.getMetadata());
                        if (!Constants.EXPOSE_OWNER_PRODUCER && !expose) {
                            decoderMeta.getLabels().remove(".producer");
                            decoderMeta.getLabels().remove(".owner");
                        }
                        break block120;
                    }
                    if (null != type) {
                        gts = decoder.decode(type);
                    } else {
                        gts = identical != false && lastType != GeoTimeSerie.TYPE.UNDEFINED ? decoder.decode(lastType) : decoder.decode();
                        lastType = gts.getType();
                    }
                    if (countOnly && lastCount + (long)GTSHelper.nvalues(gts) > count) {
                        gts = GTSHelper.shrinkTo(gts, (int)Math.max(count - lastCount, 0L));
                    }
                    lastCount += (long)GTSHelper.nvalues(gts);
                    if (showUUID) {
                        uuid = new UUID(gts.getClassId(), gts.getLabelsId());
                        gts.getMetadata().putToAttributes(".uuid", uuid.toString());
                    }
                    labels = new LinkedHashMap<String, String>();
                    labels.putAll(gts.getMetadata().getLabels());
                    if (!Constants.EXPOSE_OWNER_PRODUCER && !expose) {
                        labels.remove(".producer");
                        labels.remove(".owner");
                    }
                    gts.setLabels(labels);
                    if (null == base) {
                        base = gts;
                    } else if (!(merge && base.getMetadata().getName().equals(gts.getMetadata().getName()) && base.getMetadata().getLabels().equals(gts.getMetadata().getLabels()))) {
                        series.add(base);
                        base = gts;
                    } else {
                        base = GTSHelper.merge(base, gts);
                    }
                    if (fetched.addAndGet(gts.size()) > fetchLimit) {
                        sensisionLabels = new HashMap<String, String>();
                        sensisionLabels.put("consumer", Tokens.getUUID(rtoken.getBilledId()));
                        Sensision.update((String)"warp.script.fetchcount.exceeded", sensisionLabels, (Number)1);
                        throw new WarpScriptException(this.getName() + " exceeded limit of " + fetchLimit + " datapoints, current count is " + fetched.get());
                    }
                    stack.handleSignal();
                    continue;
                    break;
                }
lbl451:
                // 1 sources

                finally {
                    if (gtsiter != null) {
                        if (var57_80 != null) {
                            try {
                                gtsiter.close();
                            }
                            catch (Throwable var58_82) {
                                var57_80.addSuppressed(var58_82);
                            }
                        } else {
                            gtsiter.close();
                        }
                    }
                }
            }
            if (null != base && null == typeattr) {
                series.add(base);
            }
            base = null;
            metadatas.clear();
            ** while (true)
            finally {
                if (iter /* !! */  instanceof MetadataIterator) {
                    try {
                        iter /* !! */ .close();
                    }
                    catch (Exception count) {}
                }
            }
        }
        while (decoder.next()) {
            ts = decoder.getTimestamp();
            location = decoder.getLocation();
            elevation = decoder.getElevation();
            value = decoder.getBinaryValue();
            ++dpcount;
            gtsidx = 0;
            typename = "DOUBLE";
            if (value instanceof Long) {
                gtsidx = 1;
                typename = "LONG";
            } else if (value instanceof Boolean) {
                gtsidx = 2;
                typename = "BOOLEAN";
            } else if (value instanceof String) {
                gtsidx = 3;
                typename = "STRING";
            } else if (value instanceof byte[]) {
                gtsidx = 4;
                typename = "BINARY";
            }
            base = bases[gtsidx];
            if (null == base || !base.getMetadata().getName().equals(decoderMeta.getName()) || !base.getMetadata().getLabels().equals(decoderMeta.getLabels())) {
                bases[gtsidx] = new GeoTimeSerie();
                base = bases[gtsidx];
                series.add(base);
                base.setMetadata(decoderMeta);
                base.getMetadata().putToAttributes(typeattr, typename);
                if (null != uuid) {
                    base.getMetadata().putToAttributes(".uuid", uuid.toString());
                }
            }
            if (countOnly && lastCount + dpcount >= count) break;
            GTSHelper.setValue(base, ts, location, elevation, value, false);
        }
        if (fetched.addAndGet(dpcount) > fetchLimit) {
            sensisionLabels = new HashMap<String, String>();
            sensisionLabels.put("consumer", Tokens.getUUID(rtoken.getBilledId()));
            Sensision.update((String)"warp.script.fetchcount.exceeded", sensisionLabels, (Number)1);
            throw new WarpScriptException(this.getName() + " exceeded limit of " + fetchLimit + " datapoints, current count is " + fetched.get());
        }
        stack.handleSignal();
        lastCount += dpcount;
        ** while (true)
    }

    private Map<String, Object> paramsFromMap(Map<String, Object> map) throws WarpScriptException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        MetaSet metaset = null;
        if (map.containsKey(PARAM_METASET)) {
            if (null == this.AES_METASET) {
                throw new WarpScriptException(this.getName() + " MetaSet support not available.");
            }
            Object ms = map.get(PARAM_METASET);
            if (!(ms instanceof byte[])) {
                byte[] decoded = OrderPreservingBase64.decode(ms.toString().getBytes(StandardCharsets.US_ASCII));
                byte[] decrypted = CryptoUtils.unwrap(this.AES_METASET, decoded);
                try {
                    int len;
                    ByteArrayOutputStream out = new ByteArrayOutputStream(decrypted.length);
                    GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(decrypted));
                    byte[] buf = new byte[1024];
                    while ((len = ((InputStream)in).read(buf)) >= 0) {
                        out.write(buf, 0, len);
                    }
                    ((InputStream)in).close();
                    out.close();
                    ms = out.toByteArray();
                }
                catch (IOException e) {
                    throw new WarpScriptException(this.getName() + " encountered an invalid MetaSet.", e);
                }
            }
            metaset = new MetaSet();
            TDeserializer deser = new TDeserializer((TProtocolFactory)new TCompactProtocol.Factory());
            try {
                deser.deserialize((TBase)metaset, (byte[])ms);
            }
            catch (TException te) {
                throw new WarpScriptException(this.getName() + " was unable to decode the provided MetaSet.", te);
            }
            if (metaset.getExpiry() < System.currentTimeMillis()) {
                throw new WarpScriptException(this.getName() + " MetaSet has expired.");
            }
            try {
                ReadToken rtoken = Tokens.extractReadToken(metaset.getToken());
                Map<String, String> rtokenAttributes = rtoken.getAttributes();
                if (null != rtokenAttributes && (rtokenAttributes.containsKey(".nofetch") || rtokenAttributes.containsKey(".nofind"))) {
                    throw new WarpScriptException("Token cannot be used for fetching data.");
                }
            }
            catch (WarpScriptException wse) {
                throw new WarpScriptException(this.getName() + " MetaSet token is not valid.", wse);
            }
            params.put(PARAM_METASET, metaset);
            params.put(PARAM_TOKEN, metaset.getToken());
        }
        if (!params.containsKey(PARAM_TOKEN)) {
            if (!map.containsKey(PARAM_TOKEN)) {
                throw new WarpScriptException(this.getName() + " Missing '" + PARAM_TOKEN + "' parameter");
            }
            params.put(PARAM_TOKEN, map.get(PARAM_TOKEN));
        }
        if (map.containsKey(PARAM_GTS)) {
            Object o = map.get(PARAM_GTS);
            if (!(o instanceof List)) {
                throw new WarpScriptException(this.getName() + " invalid '" + PARAM_GTS + "' parameter, expected a list of Geo Time Series.");
            }
            ArrayList<Metadata> metadatas = new ArrayList<Metadata>();
            for (Object elt : (List)o) {
                if (!(elt instanceof GeoTimeSerie)) {
                    throw new WarpScriptException(this.getName() + " invalid '" + PARAM_GTS + "' parameter, expected a list of Geo Time Series.");
                }
                metadatas.add(new Metadata(((GeoTimeSerie)elt).getMetadata()));
            }
            params.put(PARAM_GTS, metadatas);
        }
        if (map.containsKey(PARAM_SELECTORS)) {
            Object sels = map.get(PARAM_SELECTORS);
            if (!(sels instanceof List)) {
                throw new WarpScriptException(this.getName() + " Invalid parameter '" + PARAM_SELECTORS + "'");
            }
            ArrayList<Pair> selectors = new ArrayList<Pair>();
            for (Object sel : (List)sels) {
                Object[] clslbls = PARSESELECTOR.parse(sel.toString());
                selectors.add(Pair.of((Object)clslbls[0], (Object)clslbls[1]));
            }
            params.put(PARAM_SELECTOR_PAIRS, selectors);
        } else if (map.containsKey(PARAM_SELECTOR)) {
            Object[] clslbls = PARSESELECTOR.parse(map.get(PARAM_SELECTOR).toString());
            params.put(PARAM_CLASS, clslbls[0]);
            params.put(PARAM_LABELS, clslbls[1]);
        } else if (map.containsKey(PARAM_CLASS) && map.containsKey(PARAM_LABELS)) {
            params.put(PARAM_CLASS, map.get(PARAM_CLASS));
            params.put(PARAM_LABELS, map.get(PARAM_LABELS));
        } else if (!params.containsKey(PARAM_METASET) && !params.containsKey(PARAM_GTS)) {
            throw new WarpScriptException(this.getName() + " Missing '" + PARAM_METASET + "', '" + PARAM_GTS + "', '" + PARAM_SELECTOR + "', '" + PARAM_SELECTORS + "' or '" + PARAM_CLASS + "' and '" + PARAM_LABELS + "' parameters.");
        }
        if (map.get(PARAM_TIMESPAN) instanceof Long && (Long)map.get(PARAM_TIMESPAN) < 0L) {
            if (map.containsKey(PARAM_COUNT)) {
                throw new WarpScriptException(this.getName() + " cannot be given both '" + PARAM_COUNT + "' and negative '" + PARAM_TIMESPAN + "'.");
            }
            long timespan = (Long)map.get(PARAM_TIMESPAN);
            if (Long.MIN_VALUE == timespan) {
                ++timespan;
            }
            map.put(PARAM_COUNT, -timespan);
            map.remove(PARAM_TIMESPAN);
        }
        if (map.containsKey(PARAM_COUNT)) {
            params.put(PARAM_COUNT, map.get(PARAM_COUNT));
        }
        try {
            Long[] timeRange = FETCH.computeTimeRange(map.get(PARAM_START), PARAM_START, map.get(PARAM_END), PARAM_END, map.get(PARAM_TIMESPAN), PARAM_TIMESPAN, map.get(PARAM_COUNT), PARAM_COUNT);
            params.put(PARAM_START, timeRange[0]);
            params.put(PARAM_END, timeRange[1]);
            if (null != timeRange[2]) {
                params.put(PARAM_TIMESPAN, timeRange[2]);
            }
        }
        catch (WarpScriptException wse) {
            throw new WarpScriptException(this.getName() + " given invalid parameters.", wse);
        }
        if (null != metaset) {
            if (map.containsKey(PARAM_BOUNDARY_PRE) || map.containsKey(PARAM_BOUNDARY_POST)) {
                throw new WarpScriptException(this.getName() + " cannot support both MetaSet and pre/post boundary parameters.");
            }
            if (metaset.isSetMaxduration()) {
                if (!metaset.isSetNotbefore() && !metaset.isSetNotafter()) {
                    params.put(PARAM_END, TimeSource.getTime());
                }
                if (!(metaset.getMaxduration() < 0L || params.containsKey(PARAM_TIMESPAN) && (Long)params.get(PARAM_TIMESPAN) <= metaset.getMaxduration())) {
                    params.put(PARAM_TIMESPAN, metaset.getMaxduration());
                }
                if (!(metaset.getMaxduration() >= 0L || params.containsKey(PARAM_COUNT) && (Long)params.get(PARAM_COUNT) <= -metaset.getMaxduration())) {
                    params.put(PARAM_COUNT, -metaset.getMaxduration());
                }
            }
            if (metaset.isSetNotbefore() && (Long)params.get(PARAM_END) < metaset.getNotbefore()) {
                params.put(PARAM_END, metaset.getNotbefore());
            }
            if (metaset.isSetNotafter() && (Long)params.get(PARAM_END) > metaset.getNotafter()) {
                params.put(PARAM_END, metaset.getNotafter());
            }
            if (params.containsKey(PARAM_TIMESPAN)) {
                try {
                    if (0L == (Long)params.get(PARAM_TIMESPAN) && Long.MAX_VALUE == (Long)params.get(PARAM_END)) {
                        throw new WarpScriptException(this.getName() + " use of MetaSet restrictions make it so '" + PARAM_TIMESPAN + "' is 0 and '" + PARAM_START + "' is MIN_VALUE, which is not supported.");
                    }
                    long newStart = Math.subtractExact((Long)params.get(PARAM_END), (Long)params.get(PARAM_TIMESPAN)) + 1L;
                    params.put(PARAM_START, newStart);
                }
                catch (ArithmeticException ae) {
                    params.put(PARAM_START, Long.MIN_VALUE);
                }
            }
        }
        if (map.containsKey(PARAM_TYPE)) {
            String type = map.get(PARAM_TYPE).toString();
            if (GeoTimeSerie.TYPE.LONG.name().equalsIgnoreCase(type)) {
                params.put(PARAM_TYPE, (Object)GeoTimeSerie.TYPE.LONG);
            } else if (GeoTimeSerie.TYPE.DOUBLE.name().equalsIgnoreCase(type)) {
                params.put(PARAM_TYPE, (Object)GeoTimeSerie.TYPE.DOUBLE);
            } else if (GeoTimeSerie.TYPE.STRING.name().equalsIgnoreCase(type)) {
                params.put(PARAM_TYPE, (Object)GeoTimeSerie.TYPE.STRING);
            } else if (GeoTimeSerie.TYPE.BOOLEAN.name().equalsIgnoreCase(type)) {
                params.put(PARAM_TYPE, (Object)GeoTimeSerie.TYPE.BOOLEAN);
            } else {
                throw new WarpScriptException(this.getName() + " Invalid value for parameter '" + PARAM_TYPE + "'.");
            }
        }
        if (map.containsKey(PARAM_TYPEATTR)) {
            if (map.containsKey(PARAM_TYPE)) {
                throw new WarpScriptException(this.getName() + " Incompatible parameters '" + PARAM_TYPE + "' and '" + PARAM_TYPEATTR + "'.");
            }
            params.put(PARAM_TYPEATTR, map.get(PARAM_TYPEATTR).toString());
        }
        if (map.containsKey(PARAM_EXTRA)) {
            if (params.containsKey(PARAM_METASET)) {
                throw new WarpScriptException(this.getName() + " Cannot specify '" + PARAM_EXTRA + "' when '" + PARAM_METASET + "' is used.");
            }
            if (params.containsKey(PARAM_GTS)) {
                throw new WarpScriptException(this.getName() + " Cannot specify '" + PARAM_EXTRA + "' when '" + PARAM_GTS + "' is used.");
            }
            if (!(map.get(PARAM_EXTRA) instanceof List)) {
                throw new WarpScriptException(this.getName() + " Invalid type for parameter '" + PARAM_EXTRA + "'.");
            }
            HashSet<String> extra = new HashSet<String>();
            for (Object o : (List)map.get(PARAM_EXTRA)) {
                if (!(o instanceof String)) {
                    throw new WarpScriptException(this.getName() + " Invalid type for parameter '" + PARAM_EXTRA + "'.");
                }
                extra.add(o.toString());
            }
            params.put(PARAM_EXTRA, extra);
        }
        if (map.containsKey(PARAM_WRITE_TIMESTAMP)) {
            params.put(PARAM_WRITE_TIMESTAMP, Boolean.TRUE.equals(map.get(PARAM_WRITE_TIMESTAMP)));
        }
        if (map.containsKey(PARAM_TTL)) {
            params.put(PARAM_TTL, Boolean.TRUE.equals(map.get(PARAM_TTL)));
        }
        if (Boolean.TRUE.equals(params.get(PARAM_TTL)) && Boolean.TRUE.equals(params.get(PARAM_WRITE_TIMESTAMP))) {
            throw new WarpScriptException(this.getName() + " Only one of '" + PARAM_WRITE_TIMESTAMP + "' and '" + PARAM_TTL + "' can be set to true.");
        }
        if (map.containsKey(PARAM_ACTIVE_AFTER)) {
            if (!(map.get(PARAM_ACTIVE_AFTER) instanceof Long)) {
                throw new WarpScriptException(this.getName() + " Invalid type for parameter '" + PARAM_ACTIVE_AFTER + "'.");
            }
            params.put(PARAM_ACTIVE_AFTER, (Long)map.get(PARAM_ACTIVE_AFTER) / Constants.TIME_UNITS_PER_MS);
        }
        if (map.containsKey(PARAM_QUIET_AFTER)) {
            if (!(map.get(PARAM_QUIET_AFTER) instanceof Long)) {
                throw new WarpScriptException(this.getName() + " Invalid type for parameter '" + PARAM_QUIET_AFTER + "'.");
            }
            params.put(PARAM_QUIET_AFTER, (Long)map.get(PARAM_QUIET_AFTER) / Constants.TIME_UNITS_PER_MS);
        }
        if (map.containsKey(PARAM_SHOWUUID)) {
            params.put(PARAM_SHOWUUID, map.get(PARAM_SHOWUUID));
        }
        if (map.containsKey(PARAM_BOUNDARY)) {
            Object o = map.get(PARAM_BOUNDARY);
            if (!(o instanceof Long)) {
                throw new WarpScriptException(this.getName() + " Invalid type for parameter '" + PARAM_BOUNDARY + "'.");
            }
            long boundary = (Long)o;
            params.put(PARAM_BOUNDARY_PRE, boundary);
            params.put(PARAM_BOUNDARY_POST, boundary);
        }
        if (map.containsKey(PARAM_BOUNDARY_PRE)) {
            Object o = map.get(PARAM_BOUNDARY_PRE);
            if (!(o instanceof Long)) {
                throw new WarpScriptException(this.getName() + " Invalid type for parameter '" + PARAM_BOUNDARY_PRE + "'.");
            }
            long boundary = (Long)o;
            params.put(PARAM_BOUNDARY_PRE, boundary);
        }
        if (map.containsKey(PARAM_BOUNDARY_POST)) {
            Object o = map.get(PARAM_BOUNDARY_POST);
            if (!(o instanceof Long)) {
                throw new WarpScriptException(this.getName() + " Invalid type for parameter '" + PARAM_BOUNDARY_POST + "'.");
            }
            long boundary = (Long)o;
            params.put(PARAM_BOUNDARY_POST, boundary);
        }
        if (map.containsKey(PARAM_SKIP)) {
            Object o = map.get(PARAM_SKIP);
            if (!(o instanceof Long)) {
                throw new WarpScriptException(this.getName() + " Invalid type for parameter '" + PARAM_SKIP + "'.");
            }
            long skip = (Long)o;
            if (skip < 0L) {
                throw new WarpScriptException(this.getName() + " Parameter '" + PARAM_SKIP + "' must be >= 0.");
            }
            params.put(PARAM_SKIP, skip);
        }
        if (map.containsKey(PARAM_STEP)) {
            Object o = map.get(PARAM_STEP);
            if (!(o instanceof Long)) {
                throw new WarpScriptException(this.getName() + " Invalid type for parameter '" + PARAM_STEP + "'.");
            }
            long step = (Long)o;
            if (step < 1L) {
                throw new WarpScriptException(this.getName() + " Parameter '" + PARAM_STEP + "' must be >= 1.");
            }
            params.put(PARAM_STEP, step);
        }
        if (map.containsKey(PARAM_TIMESTEP)) {
            Object o = map.get(PARAM_TIMESTEP);
            if (!(o instanceof Long)) {
                throw new WarpScriptException(this.getName() + " Invalid type for parameter '" + PARAM_TIMESTEP + "'.");
            }
            long timestep = (Long)o;
            if (timestep < 1L) {
                throw new WarpScriptException(this.getName() + " Parameter '" + PARAM_TIMESTEP + "' must be >= 1.");
            }
            params.put(PARAM_TIMESTEP, timestep);
        }
        if (map.containsKey(PARAM_SAMPLE)) {
            Object o = map.get(PARAM_SAMPLE);
            if (!(o instanceof Double)) {
                throw new WarpScriptException(this.getName() + " Invalid type for parameter '" + PARAM_SAMPLE + "'.");
            }
            double sample = (Double)o;
            if (sample <= 0.0 || sample > 1.0) {
                throw new WarpScriptException(this.getName() + " Parameter '" + PARAM_SAMPLE + "' must be in the range ( 0.0, 1.0 ].");
            }
            params.put(PARAM_SAMPLE, sample);
        }
        if (map.containsKey(PARAM_LABELS_PRIORITY)) {
            Object o = map.get(PARAM_LABELS_PRIORITY);
            if (!(o instanceof List)) {
                throw new WarpScriptException(this.getName() + " Invalid type for parameter '" + PARAM_LABELS_PRIORITY + "', expected a LIST.");
            }
            ArrayList<String> prio = new ArrayList<String>();
            for (Object oo : (List)o) {
                prio.add(String.valueOf(oo));
            }
            params.put(PARAM_LABELS_PRIORITY, prio);
        }
        if (map.containsKey(PARAM_ENCODERS)) {
            params.put(PARAM_ENCODERS, Boolean.TRUE.equals(map.get(PARAM_ENCODERS)));
        }
        if (map.containsKey(PARAM_MERGE)) {
            params.put(PARAM_MERGE, Boolean.TRUE.equals(map.get(PARAM_MERGE)));
        }
        return params;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Long[] computeTimeRange(Object start, String startParamName, Object end, String endParamName, Object timespan, String timespanParamName, Object count, String countParamName) throws WarpScriptException {
        long now = TimeSource.getTime();
        Long startTs = FETCH.getTimestamp(start, startParamName, now);
        Long endTs = FETCH.getTimestamp(end, endParamName, now);
        if (null == startTs && null == endTs) {
            throw new WarpScriptException("Missing either '" + startParamName + "' or '" + endParamName + "' parameter.");
        }
        if (null != startTs && null != endTs && startTs > endTs) {
            long tmp = startTs;
            startTs = endTs;
            endTs = tmp;
        }
        Long numericTimespan = null;
        if (null != timespan) {
            if (startTs != null && endTs != null) {
                throw new WarpScriptException("Invalid time range specification: '" + startParamName + "', '" + endParamName + "' and '" + timespanParamName + "' cannot all be defined. Only 2 out of those 3 parameters should be defined.");
            }
            if (timespan instanceof Long) {
                numericTimespan = (Long)timespan;
            } else {
                if (!(timespan instanceof String)) throw new WarpScriptException("Invalid format for parameter '" + timespanParamName + "'.");
                if (0 == ((String)timespan).length()) throw new WarpScriptException("Parameter '" + timespanParamName + "' is empty.");
                try {
                    if ('P' == ((String)timespan).charAt(0)) {
                        MutablePeriod period = new MutablePeriod();
                        ISOPeriodFormat.standard().getParser().parseInto((ReadWritablePeriod)period, (String)timespan, 0, Locale.US);
                        Period p = period.toPeriod();
                        if (p.getMonths() != 0 || p.getYears() != 0) {
                            throw new WarpScriptException("No support for ambiguous durations containing years or months, please convert those to days.");
                        }
                        Duration duration = p.toDurationFrom((ReadableInstant)new Instant());
                        numericTimespan = duration.getMillis() * Constants.TIME_UNITS_PER_MS;
                    } else {
                        numericTimespan = Long.parseLong((String)timespan);
                    }
                }
                catch (WarpScriptException | IllegalArgumentException e) {
                    throw new WarpScriptException("Invalid format for parameter '" + timespanParamName + "'.", e);
                }
            }
            if (numericTimespan < 0L) {
                throw new WarpScriptException("'" + timespanParamName + "' cannot be negative.");
            }
            if (null == startTs) {
                if (0L == numericTimespan && Long.MAX_VALUE == endTs) {
                    throw new WarpScriptException("Cannot set '" + timespanParamName + "' to 0 and '" + endParamName + "' to MAX_VALUE.");
                }
                try {
                    startTs = Math.subtractExact(endTs, numericTimespan) + 1L;
                }
                catch (ArithmeticException ae) {
                    startTs = Long.MIN_VALUE;
                }
            } else {
                if (0L == numericTimespan && Long.MIN_VALUE == startTs) {
                    throw new WarpScriptException("Cannot set '" + timespanParamName + "' to 0 and '" + startParamName + "' to MIN_VALUE.");
                }
                try {
                    endTs = Math.addExact(startTs, numericTimespan) - 1L;
                }
                catch (ArithmeticException ae) {
                    endTs = Long.MAX_VALUE;
                }
            }
        }
        if (null == endTs) {
            throw new WarpScriptException("Missing '" + endParamName + "' or '" + startParamName + "' and '" + timespanParamName + "' parameter.");
        }
        if (null != startTs) return new Long[]{startTs, endTs, numericTimespan};
        if (null == count) {
            throw new WarpScriptException("Invalid time range specification: '" + countParamName + "' is mandatory if '" + startParamName + "' and '" + timespanParamName + "' are not specified.");
        }
        startTs = Long.MIN_VALUE;
        return new Long[]{startTs, endTs, numericTimespan};
    }

    public static Long getTimestamp(Object timestampRepresentation, String timestampRepresentationParameterName, Long nowTimestamp) throws WarpScriptException {
        Long timestamp = null;
        if (timestampRepresentation instanceof Long) {
            timestamp = (long)((Long)timestampRepresentation);
        } else if (timestampRepresentation instanceof String) {
            if (NOW_PARAM_VALUE.equals(timestampRepresentation)) {
                timestamp = nowTimestamp;
            } else {
                try {
                    timestamp = Long.parseLong((String)timestampRepresentation);
                }
                catch (NumberFormatException nfe) {
                    try {
                        timestamp = TOTIMESTAMP.parseTimestamp((String)timestampRepresentation);
                    }
                    catch (WarpScriptException | IllegalArgumentException e) {
                        throw new WarpScriptException("Invalid format for parameter '" + timestampRepresentationParameterName + "'.");
                    }
                }
            }
        } else if (null != timestampRepresentation) {
            throw new WarpScriptException("Invalid format for parameter '" + timestampRepresentationParameterName + "'.");
        }
        return timestamp;
    }
}

