/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.warp.sdk.Capabilities;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.Arrays;

public class ECRECOVER
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final String KEY_R = "r";
    private static final String KEY_S = "s";
    private static final String KEY_I = "i";
    private static final String KEY_EVEN = "even";
    private static final String KEY_SIG = "sig";
    private static final String KEY_HASH = "hash";
    private static final String KEY_CURVE = "curve";
    private static final String CAP_COFACTOR = "ecc.h";
    private static final int MAX_COFACTOR = 10;

    public ECRECOVER(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        BigInteger s;
        BigInteger r;
        Object top = stack.pop();
        if (!(top instanceof Map)) {
            throw new WarpScriptException(this.getName() + " expects a MAP.");
        }
        Map params = (Map)top;
        if (!(params.get(KEY_CURVE) instanceof String)) {
            throw new WarpScriptException(this.getName() + " missing ECC curve name under '" + KEY_CURVE + "'.");
        }
        final ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)((String)params.get(KEY_CURVE)));
        BigInteger H = spec.getH();
        if (!(params.get(KEY_HASH) instanceof byte[])) {
            throw new WarpScriptException(this.getName() + " invalid '" + KEY_HASH + "', expected BYTES.");
        }
        if (null != params.get(KEY_SIG)) {
            if (!(params.get(KEY_SIG) instanceof byte[])) {
                throw new WarpScriptException(this.getName() + " invalid '" + KEY_SIG + "', expected BYTES.");
            }
            byte[] sig = (byte[])params.get(KEY_SIG);
            int offset = 0;
            if (0 != (sig[1] & 0x80)) {
                offset = 2;
                int len = 0;
                for (int sbytes = (sig[1] & 0xFF) - 128; sbytes > 0; --sbytes) {
                    len <<= 8;
                    len |= sig[offset++] & 0xFF;
                }
            } else {
                offset = 2;
            }
            int n = ++offset;
            byte rlen = sig[n];
            r = new BigInteger(1, Arrays.copyOfRange((byte[])sig, (int)(++offset), (int)(offset + rlen)));
            offset += rlen;
            s = new BigInteger(1, Arrays.copyOfRange((byte[])sig, (int)(offset += 2), (int)sig.length));
            if (r.compareTo(spec.getN()) > 0 || r.compareTo(BigInteger.ONE) < 0) {
                throw new WarpScriptException(this.getName() + " invalid value for r, should be in [1, 0x00" + spec.getN().toString(16) + "] but was 0x" + r.toString(16) + ".");
            }
            if (s.compareTo(spec.getN()) > 0 || s.compareTo(BigInteger.ONE) < 0) {
                throw new WarpScriptException(this.getName() + " invalid value for s, should be in [1, 0x00" + spec.getN().toString(16) + "] but was 0x" + s.toString(16) + ".");
            }
        } else if (null != params.get(KEY_R) && null != params.get(KEY_S)) {
            if (!(params.get(KEY_R) instanceof String)) {
                throw new WarpScriptException(this.getName() + " invalid '" + KEY_R + "', expected STRING.");
            }
            if (!(params.get(KEY_S) instanceof String)) {
                throw new WarpScriptException(this.getName() + " invalid '" + KEY_S + "', expected STRING.");
            }
            String str = ((String)params.get(KEY_R)).toLowerCase();
            r = str.startsWith("0x") ? new BigInteger("00" + str.substring(2), 16) : new BigInteger(str);
            str = ((String)params.get(KEY_S)).toLowerCase();
            s = str.startsWith("0x") ? new BigInteger("00" + str.substring(2), 16) : new BigInteger(str);
        } else {
            throw new WarpScriptException(this.getName() + " expects '" + KEY_SIG + "' or '" + KEY_R + "' and '" + KEY_S + "' to be provided.");
        }
        int nbits = spec.getN().bitLength();
        byte[] hash = (byte[])params.get(KEY_HASH);
        BigInteger z = new BigInteger(1, hash);
        if (nbits < hash.length * 8) {
            z = z.shiftRight(hash.length * 8 - nbits);
        }
        BigInteger rinv = spec.getCurve().fromBigInteger(r.modInverse(spec.getN())).toBigInteger();
        int minH = 0;
        int maxH = H.intValue();
        if (params.get(KEY_I) instanceof Long) {
            minH = ((Long)params.get(KEY_I)).intValue();
            maxH = minH + 1;
        }
        if (maxH - minH > 10) {
            String hmaxCap = Capabilities.get(stack, CAP_COFACTOR);
            try {
                int hmax = Integer.valueOf(hmaxCap);
                if (maxH > hmax) {
                    throw new WarpScriptException(this.getName() + " cofactor " + maxH + " is above the maximum " + hmax + " allowed by the '" + CAP_COFACTOR + "' capability.");
                }
            }
            catch (NumberFormatException nfe) {
                throw new WarpScriptException(this.getName() + " cofactor " + maxH + " is above allowed maximum " + 10 + ", increase this limit using a token with the '" + CAP_COFACTOR + "' capability.");
            }
        }
        HashSet<String> candidates = new HashSet<String>();
        int mintype = 2;
        int maxtype = 3;
        if (params.get(KEY_EVEN) instanceof Boolean) {
            if (Boolean.TRUE.equals(params.get(KEY_EVEN))) {
                mintype = 2;
                maxtype = 2;
            } else {
                mintype = 3;
                maxtype = 3;
            }
        }
        for (int j = minH; j < maxH; ++j) {
            for (int type = mintype; type <= maxtype; ++type) {
                try {
                    BigInteger x = r.add(BigInteger.valueOf(j).multiply(spec.getN()));
                    X9IntegerConverter x9 = new X9IntegerConverter();
                    byte[] encoded = x9.integerToBytes(x, 1 + x9.getByteLength(spec.getCurve()));
                    encoded[0] = (byte)type;
                    ECPoint R = spec.getCurve().decodePoint(encoded).normalize();
                    if (!R.multiply(spec.getN()).isInfinity()) continue;
                    ECPoint Rprime = spec.getCurve().createPoint(x, R.getYCoord().negate().toBigInteger()).normalize();
                    ECPoint Q1 = R.multiply(s).subtract(spec.getG().multiply(z)).multiply(rinv).normalize();
                    candidates.add(new String(Q1.getEncoded(false), StandardCharsets.ISO_8859_1));
                    ECPoint Q2 = Rprime.multiply(s).subtract(spec.getG().multiply(z)).multiply(rinv).normalize();
                    candidates.add(new String(Q2.getEncoded(false), StandardCharsets.ISO_8859_1));
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    continue;
                }
                catch (IllegalStateException ise) {
                    // empty catch block
                }
            }
        }
        ArrayList<1> keys = new ArrayList<1>(candidates.size());
        for (String qstr : candidates) {
            final byte[] encoded = qstr.getBytes(StandardCharsets.ISO_8859_1);
            final ECPoint Q = spec.getCurve().decodePoint(encoded);
            keys.add(new ECPublicKey(){

                public String getFormat() {
                    return "PKCS#8";
                }

                public byte[] getEncoded() {
                    return encoded;
                }

                public String getAlgorithm() {
                    return "EC";
                }

                public ECPoint getQ() {
                    return Q;
                }

                public ECParameterSpec getParameters() {
                    return spec;
                }
            });
        }
        stack.push(keys);
        return stack;
    }
}

